import FileSaver from 'file-saver'
import XLSX from 'xlsx'

export function exportExcel(id, title) {
  var wb = XLSX.utils.table_to_book(document.querySelector("#" + id));
  var wbout = XLSX.write(wb, {
    bookType: "xlsx",
    bookSST: true,
    type: "array"
  });

  try {
    FileSaver.saveAs(
      new Blob([wbout], { type: "application/octet-stream" }),
      title + ".xlsx"
    );
  } catch (e) {
    if (typeof console !== "undefined") console.log(e, wbout);
  }

  return wbout;
}
