import request from '@/utils/request'

// 分页获取资源组列表
export function getResourceGroupsByPage(params) {
  return request({
    // url: `http://localhost:8567/resource-groups/page`,
    url: `${process.env.PUTIN_API}/resource-groups/page`,
    method: 'post',
    params
  })
}

// 创建资源组
export function createResourceGroup(data) {
  return request({
    url: `${process.env.PUTIN_API}/resource-groups/add`,
    // url: `http://localhost:8567/resource-groups/add`,
    method: 'post',
    data
  })
}

// 根据ID获取资源组
export function getResourceGroupById(id) {
  return request({
    url: `${process.env.PUTIN_API}/resource-groups/${id}`,
    method: 'get'
  })
}

// 更新资源组
export function updateResourceGroup(id, data) {
  return request({
    url: `${process.env.PUTIN_API}/resource-groups/${id}`,
    method: 'put',
    data
  })
}

// 删除资源组
export function deleteResourceGroup(id) {
  return request({
    url: `${process.env.PUTIN_API}/resource-groups/${id}`,
    method: 'delete'
  })
}

// 获取资源组详情页文件列表
export function getResourceGroupDetailPage(params) {
  return request({
    // url: `http://localhost:8567/resource-groups/detailPage`,
    url: `${process.env.PUTIN_API}/resource-groups/detailPage`,
    method: 'post',
    params
  })
}

// 获取资源组下拉列表
export function getResourceGroupList() {
  return request({
    // url: `http://localhost:8567/resource-groups/list`,
    url: `${process.env.PUTIN_API}/resource-groups/list`,
    method: 'get'
  })
}
