import request from "@/utils/request";

export function oceanEngineList(params) {
  return request({
    url: "/v1/data/ocean-engine/list",
    method: "get",
    params
  });
}

export function oauthCallback(params) {
  return request({
    url: "/v1/data/ocean-engine/oauth/callback",
    method: "get",
    params
  });
}

export function gdtCallback(params) {
  return request({
    url: "/v1/gdt/callback",
    method: "get",
    params
  });
}

export function kuaishouCallback(params) {
  return request({
    url: "/v1/kuaishou/callback",
    method: "get",
    params
  });
}

export function weiboCallback(params) {
  return request({
    url: "/v1/weibo/callback",
    method: "get",
    params
  });
}

export function tiktokCallback(params) {
  return request({
    url: "/v1/tiktok/callback",
    method: "get",
    params
  });
}

export function ceanEngineUpdate(data) {
  return request({
    url: "/v1/data/ocean-engine/update",
    method: "post",
    data
  });
}

export function diff(params) {
  return request({
    url: "/data/api/puton/cost/diff",
    method: "get",
    params
  });
}

export function statusManage(_method, _params) {
  if (_method === "get" || _method === "delete") {
    return request({
      url: "/data/api/puton/status/manage",
      method: _method,
      params: _params
    });
  } else {
    return request({
      url: "/data/api/puton/status/manage",
      method: _method,
      data: _params
    });
  }
}
