import axios from 'axios'

// 获取所有标签
export function getAllMaterialTags() {
  return axios.get(process.env.PUTIN_API + '/material_tags')
    .then(response => {
      return response.data
    })
}

// 获取单个标签
export function getMaterialTagById(id) {
  return axios.get(`${process.env.PUTIN_API}/material_tags/${id}`)
    .then(response => {
      return response.data
    })
}

// 创建标签
export function createMaterialTag(data) {
  return axios.post(`${process.env.PUTIN_API}/material_tags`, data)
    .then(response => {
      return response.data
    })
}

// 更新标签
export function updateMaterialTag(data) {
  return axios.put(`${process.env.PUTIN_API}/material_tags`, data)
    .then(response => {
      return response.data
    })
}

// 删除标签
export function deleteMaterialTag(id) {
  return axios.delete(`${process.env.PUTIN_API}/material_tags/${id}`)
    .then(response => {
      return response.data
    })
}

// 批量为素材添加标签
export function batchAddTagsToMaterials(materialIds, tagIds) {
  return axios.post(`${process.env.PUTIN_API}/material/batch`, {
    materialIds,
    tagIds
  }).then(response => {
    return response.data
  })
}
