// Echarts 配置项
let option = {
    baseOption: {
        backgroundColor: '#00336600', //背景颜色
        timeline: {
            axisType: 'category',
            autoPlay: false,
            playInterval: 1800, //播放速度
            //控制时间线的位置
            left: '10%',
            right: '10%',
            bottom: '0%',
            width: '80%',
            label: {
                normal: {
                    textStyle: {
                        color: 'rgb(46,200,207)',
                    }
                },
                emphasis: {
                    textStyle: {
                        color: 'rgb(57,89,255)'
                    }
                }
            },
            symbolSize: 12,
            lineStyle: {
                color: 'rgb(46,200,207)'
            },
            checkpointStyle: {
                color: "rgb(57,89,255)",
                borderColor: 'rgb(46,200,207)',
                borderWidth: 2
            },
            controlStyle: {
                showNextBtn: true,
                showPrevBtn: true,
                normal: {
                    color: 'rgb(46,200,207)',
                    borderColor: 'rgb(46,200,207)'
                },
                emphasis: {
                    color: 'rgb(57,89,255)',
                    borderColor: 'rgb(57,89,255)'
                }
            },

        },
        title: {
            text: '',
            right: '10%',
            top: '10%',
            textStyle: {
                fontSize: 26,
                color: 'rgb(46,200,207)' //标题字体颜色
            }
        },
        tooltip: {
            'trigger': 'axis'
        },
        calculable: true,
        grid: { //图表位置控制
            left: '5%',
            right: '5%',
            bottom: '20%',
            top: '10%',
            containLabel: true
        },
        label: {
            normal: {
                textStyle: {
                    color: '#000'
                }
            }
        },
        xAxis: [{
            'type': 'category',
            nameGap: 50,
            offset: '37',
            interval: 50,
            data: '',
            nameTextStyle: {
                color: '#000'
            },
            axisLabel: {
                show: false,
                textStyle: {
                    fontSize: 32,
                    color: "black", // 标签国家字体颜色
                },
                interval: 50
            },
            axisLine: {
                lineStyle: {
                    color: 'rgb(57,89,255,1)' //x轴颜色
                },
            },
            splitLine: {
                show: false,
                lineStyle: {
                    color: '#AAA'
                }
            },
        }],
        yAxis: [{
            'type': 'value',
            'name': '',
            splitNumber: 10, //轴线个数
            nameTextStyle: {
                color: 'balck'
            },
            axisLine: {
                lineStyle: {
                    color: 'rgb(57,89,255)' //y轴颜色
                }
            },
            axisLabel: {
                formatter: '{value} '
            },
            splitLine: {
                show: true,
                lineStyle: {
                    color: '#CCCC'
                }
            },
        }],
        series: [{
            'name': '',
            'type': 'bar',
            markLine: {
                label: {
                    normal: {
                        show: false
                    }
                },
                lineStyle: {
                    normal: {
                        color: 'red',
                        width: 3
                    }
                },
            },
            label: {
                normal: {
                    show: true,
                    position: 'bottom', //数值显示位置
                    formatter: '{c}'
                },
                emphasis: {
                    color: "rgb(57,89,255)",
                }
            },
            itemStyle: {
                normal: {
                    color: "rgb(46,200,207)", //数值颜色居于顶部的
                }
            },
        },
        {
            'name': '',
            'type': 'bar',
            markLine: {
                label: {
                    normal: {
                        show: false,
                    }
                },
                lineStyle: {
                    normal: {
                        color: 'black',
                        width: 3
                    }
                },
            },
            barWidth: '50%',
            barGap: '-100%',
            label: {
                normal: {
                    show: true,
                    fontSize: 16,  //标签国家字体大小
                    position: 'top', //国家显示在位置
                    formatter: function (p) {
                        return p.name;
                    }
                },
                emphasis: {
                    color: "rgb(57,89,255)",
                }
            },
            itemStyle: {
                normal: {
                    color: "rgb(46,200,207)", //柱状图的颜色
                },
                emphasis: {
                    color: "rgb(57,89,255)",
                }
            },
        }
        ],
        animationEasingUpdate: 'quinticInOut',
        animationDurationUpdate: 1000, //动画效果
    },
    options: []
};

export default {
    option
}