import { loginV2, logout, getInfoV2 } from "@/api/login";
import { getToken, setToken,getRole, setRole, removeToken } from "@/utils/auth";
import { appList } from "@/api/const";

const user = {
  state: {
    token: getToken(),
    name: "",
    avatar: "",
    roles: [],
  },

  mutations: {
    SET_TOKEN: (state, token) => {
      state.token = token;
    },
    SET_NAME: (state, name) => {
      state.name = name;
    },
    SET_AVATAR: (state, avatar) => {
      state.avatar = avatar;
    },
    SET_ROLES: (state, roles) => {
      state.roles = roles;
    }
  },

  actions: {
    // 登录
    Login({ commit }, userInfo) {
      const username = userInfo.username.trim();
      return new Promise((resolve, reject) => {
        loginV2(username, userInfo.password)
          .then(response => {
            const data = response.result.data;
            window.localStorage.setItem('uid', data.info.id)
            window.localStorage.setItem('roles', data.info.roles.map(i => i.roleCode))

            appList().then(res => {
              let pkgOption = res.result.data;
              window.localStorage.setItem(
                "pkgOption",
                JSON.stringify(pkgOption)
              );
            });

            setToken(data.token);
            commit("SET_TOKEN", data.token);
            resolve();
          })
          .catch(error => {
            reject(error);
          });
      });
    },

    // 获取用户信息
    GetInfo({ commit, state }) {
      return new Promise((resolve, reject) => {
        getInfoV2(state.token)
          .then(response => {
            const data = response.result.data;
            // if (data.roles && data.roles.length > 0) { // 验证返回的roles是否是一个非空数组
            //   commit('SET_ROLES', data.roles)
            // } else {
            //   reject('getInfo: roles must be a non-null array !')
            // }
            commit("SET_NAME", data.realName);
            commit("SET_AVATAR", data.avatar);
            resolve(response);
          })
          .catch(error => {
            reject(error);
          });
      });
    },

    // 登出
    LogOut({ commit, state }) {
      return new Promise((resolve, reject) => {
        logout(state.token)
          .then(() => {
            window.localStorage.setItem("pkgOption", "");

            commit("SET_TOKEN", "");
            commit("SET_ROLES", []);
            removeToken();
            resolve();
          })
          .catch(error => {
            reject(error);
          });
      });
    },

    // 前端 登出
    FedLogOut({ commit }) {
      return new Promise(resolve => {
        window.localStorage.setItem("pkgOption", "");

        commit("SET_TOKEN", "");
        removeToken();
        resolve();
      });
    }
  }
};

export default user;
