import request from '@/utils/request'

export function getCampaignTemplateList(params) {
  return request({
    url: process.env.PUTIN_API + '/campaign-templates',
    method: 'get',
    params
  })
}

export function getCampaignTemplateById(id) {
  return request({
    url: process.env.PUTIN_API + `/campaign-templates/${id}`,
    method: 'get'
  })
}

export function createCampaignTemplate(data) {
  return request({
    url: process.env.PUTIN_API + '/campaign-templates',
    method: 'post',
    data
  })
}

export function updateCampaignTemplate(data) {
  return request({
    url: process.env.PUTIN_API + '/campaign-templates',
    method: 'put',
    data
  })
}

export function deleteCampaignTemplate(id) {
  return request({
    url: process.env.PUTIN_API + `/campaign-templates/${id}`,
    method: 'delete'
  })
}
