export const pickerOptions = {
    disabledDate(time) {
        return time.getTime() > Date.now();
    },
    shortcuts: [{
        text: '今天',
        onClick(picker) {
            picker.$emit('pick', new Date());
        }
    }, {
        text: '昨天',
        onClick(picker) {
            const date = new Date();
            date.setTime(date.getTime() - 3600 * 1000 * 24);
            picker.$emit('pick', date);
        }
    }, {
        text: '一周前',
        onClick(picker) {
            const date = new Date();
            date.setTime(date.getTime() - 3600 * 1000 * 24 * 7);
            picker.$emit('pick', date);
        }
    }]
};

export const putLIst = [
    { label: "全部", value: "" },
    { label: "代投", value: "1" },
    { label: "自投", value: "2" }
]

export const planStatusList = [
    { label: "全部", value: "" },
    { label: "启用", value: "AD_STATUS_ENABLE" },
    { label: "暂停", value: "AD_STATUS_DISABLE" },

]

export const planPutStatus = [
    { label: "全部", value: "" },
    { label: "投放中", value: "AD_STATUS_DELIVERY_OK" },
    { label: "计划暂停", value: "AD_STATUS_DISABLE" },
    { label: "审核不通过", value: "AD_STATUS_AUDIT_DENY" },
    { label: "已被广告组暂停", value: "AD_STATUS_CAMPAIGN_DISABLE" },
    { label: "已删除", value: "AD_STATUS_DELETE" }
    //映射显示所用
    // { label: "投放中", value: "AD_STATUS_DELIVERY_OK" },
    // { label: "计划暂停", value: "AD_STATUS_DISABLE" },
    // { label: "新建审核中", value: "AD_STATUS_AUDIT" },
    // { label: "修改审核中", value: "AD_STATUS_REAUDIT" },
    // { label: "已完成（投放达到结束时间）", value: "AD_STATUS_DONE" },
    // { label: "计划新建", value: "AD_STATUS_CREATE" },
    // { label: "审核不通过", value: "AD_STATUS_AUDIT_DENY" },
    // { label: "账户余额不足", value: "AD_STATUS_BALANCE_EXCEED" },
    // { label: "超出预算", value: "AD_STATUS_BUDGET_EXCEED" },
    // { label: "未达到投放时间", value: "AD_STATUS_NOT_START" },
    // { label: "不在投放时段", value: "AD_STATUS_NO_SCHEDULE" },
    // { label: "已被广告组暂停", value: "AD_STATUS_CAMPAIGN_DISABLE" },
    // { label: "广告组超出预算", value: "AD_STATUS_CAMPAIGN_EXCEED" },
    // { label: "已删除", value: "AD_STATUS_DELETE" },
    // { label: "超出广告主预算", value: "AD_STATUS_ADVERTISER_BUDGET_EXCEED" },
]

export const planAssessLIst = [
    { label: "全部", value: "" },
    { label: "建议观察", value: "SUGGEST_OBSERVE" },
    { label: "关停计划", value: "STOP_PLAN" },
    { label: "降低出价", value: "REDUCE_BID" },
    { label: "提高出价", value: "UP_BID" },
    { label: "持续放量", value: "CONTINUE_PUTIN" },
]