import request from "@/utils/request";

export function getRoiData(params) {
  return request({
    url: process.env.BXDD_API + "/data/api/roi/agent/roiData",
    method: "get",
    params
  });
}

// 获取页面App列表权限
export function menuSelectApps(params) {
  return request({
    url: process.env.BXDD_API + "/cms/menu/selectApps",
    method: "get",
    params
  });
}

// 获取创建的素材组列表
export function materialGroupList(params) {
  return request({
    url: process.env.PUTIN_API + "/material/v2/group/list",
    method: "get",
    params
  });
}

// 获取投放账号列表
export function putinFetchAccount(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/fetch/account",
    method: "get",
    params
  });
}

// 获取转化ID列表
export function putinFetchConvertIds(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/fetch/convert-ids",
    method: "get",
    params
  });
}

// 更新或新增投放账号转化ID
export function putinUpdateAdvertiseConversion(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/update/advertise/conversion",
    method: "post",
    params
  });
}

// 创建投放任务
export function putinCreatePutinTask(data) {
  return request({
    url: process.env.PUTIN_API + "/putin/task/createPutinTask",
    method: "post",
    data
  });
}

// 获取人群包列表
export function getCrowdList(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/fetch/custom_audience/select",
    method: "get",
    params
  });
}

//  获取已创建的定向包
export function getCreatedDirectPkg(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/fetch/his/orientation",
    method: "get",
    params
  });
}

// 抓取创意三级分类信息列表
export function putinFetchIndustryList(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/fetch/industryList",
    method: "get",
    params
  });
}

// 投放归因
export function putinFetchAttribution_analysis(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/fetch/attribution_analysis",
    method: "get",
    params
  });
}

//获取图片尺寸列
export function getPictureSizeLsit(params) {
  return request({
    url: process.env.PUTIN_API + "/material/fetch/materialSize",
    method: "get",
    params
  });
}

//获取行动号召列表
export function getCallActionList(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/action/texts",
    method: 'get',
    params
  })
}

//智能投放->投放归因，更改 广告组、广告计划、创意 状态
export function attributionStatusChange(params) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/update/status",
    method: "post",
    params
  });
}

//获取试玩素材列表
export function getPlayableUrlListAPI(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/fetch/play/list",
    method: "get",
    params
  });
}

// 获取广告主下的广告组列表
export function getAdvList(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/fetch/campaign-ids",
    method: "get",
    params
  })
}

/**
 * 通过sqlID来请求数据，不同id参数和返回值不同
 */
export function getAttributeGraphApi(params) {
  return request({
    url: process.env.BXDD_API + "/stat/common/v2/tableMapping",
    method: "get",
    params
  })
}

/**
 * 投放归因页面 修改广告主下的出价OCMP字段，单次修改一个广告主下的所有
 */
export function modifyAdvertiserOcmp(data) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/batch/task",
    method: "post",
    data
  })
}

/**
 * 获取任务中心的列表
 */
export function getTaskList(params) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/common/taskList",
    method: "get",
    params
  })
}

/**
 * Ocmp相关操作
 *   post提交任务(上面接口就是提交任务)
 *   get拉取详细列表
 *   put开启任务
 */
export function handleAdvertiserOcmp(params, means) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/batch/task",
    method: means,
    params
  })
}

/**
 * 通用接口通过sqlid来区分获取不同的数据
 * @param {Object} params
 */
export function v2TableMappingAPI(params) {
  return request({
    url: process.env.BXDD_API + "/stat/common/v2/tableMapping",
    method: "get",
    params
  })
}

/**
 * 智能投放->投放归因，广告计划 预算和出价更改
 */
export function planRevision(params) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/plan",
    method: "post",
    params
  });
}

/**
 * 投放考核 列表获取
 */
export function putAssessGetList(params) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/checkIndex/list",
    method: "get",
    params
  })
}

/**
 * 投放考核 编辑考核值
 */
export function putAssessEditSave(data) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/fill/checkIndex",
    method: "post",
    data
  })
}

/**
 * 投放考核 列表获取V2
 */
export function putAssessGetListV2(params) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/checkIndex/list/v2",
    method: "get",
    params
  })
}

/**
 * 投放考核 编辑考核值V2
 */
export function putAssessEditSaveV2(data) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/fill/checkIndex/v2",
    method: "post",
    data
  })
}

/**
 * 下面三个是计划修改组件所需接口
 */
export function fetchPlanInfo(params) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/planInfo",
    method: "get",
    params
  });
}

export function opPutinPlan(params) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/plan",
    method: "post",
    params
  });
}


export function fetchHis(params) {
  return request({
    url: process.env.PUTIN_API + "/op/putin/history",
    method: "get",
    params
  });
}

// 试玩素材列表获取(自有库)
export function tryPlayList(params) {
  return request({
    url: process.env.PUTIN_API + '/putin/fetch/play-material',
    method: 'get',
    params
  })
}

// 试玩素材上传-保存试玩素材
export function uploadSaveMaterial(params) {
  return request({
    url: process.env.PUTIN_API + '/putin/save/play-material',
    method: 'post',
    params
  })
}

// 批量删除试玩素材(自有库)
export function batchRemove(params) {
  return request({
    url: process.env.PUTIN_API + '/putin/del/play-material',
    method: 'post',
    params
  })
}

// 上传素材到平台广告主
export function uploadToAdver(params) {
  return request({
    url: process.env.PUTIN_API + '/putin/upload/platform/play-material',
    method: 'post',
    params
  })
}

//更新或新增投放账号试玩素材
export function newAcountMaterials(params) {
  return request({
    url: process.env.PUTIN_API + '/putin/update/advertise/playable',
    method: 'post',
    params
  })
}

//获取广告主下面试玩素材的个数
export function getAdvertiseCount(params) {
  return request({
    url: process.env.PUTIN_API + "/putin/fetch/play/size",
    method: "get",
    params
  });
}

// ------广告投放配置请求---------------

// 获取列表数据
export function fetchAdvCfgList(params) {
  return request({
    url: process.env.AD_API + "/v1/putin/cfgList",
    method: "get",
    params
  });
}

// 新增/更新列表
export function updateOrAddList(data) {
  return request({
    url: process.env.AD_API + "/v1/putin/cfg",
    method: "post",
    data
  });
}

// 开关
export function switchData(params) {
  return request({
    url: process.env.AD_API + "/v1/putin/switch/cfg",
    method: "post",
    params
  });
}

// 删除
export function deletePutin(params) {
  return request({
    url: process.env.AD_API + "/v1/putin/del/cfg",
    method: "post",
    params
  });
}

// 同步缓存
export function asyncCache(params) {
  return request({
    url: process.env.AD_API + "/v1/putin/sync/cfg",
    method: "post",
    params
  });
}

// 查看计划配置详情
export function planDetailCfg(params) {
  return request({
    url: process.env.AD_API + "/v1/putin/details",
    method: "get",
    params
  });
}

// 获取包的所有投放匹配ID配置
export function matchIdCfg(params) {
  return request({
    url: process.env.AD_API + "/v1/putin/matchIds",
    method: "get",
    params
  });
}

// 虚拟回传
export function backhaul(params) {
  return request({
    url: 'http://report.zhangxinhulian.com' + '/mock/callback',
    method: "get",
    params
  })
}

export function getGoogleTokenList(params) {
  return request({
    // url: 'http://localhost:8567/youtube/getTokenList',
    url: process.env.PUTIN_API + '/youtube/getTokenList',
    method: "get",
    params
  })
}
export function getYoutubeAccountList() {
  return request({
    // url: 'http://localhost:8567/youtube/getYoutubeAccount',
    url: process.env.PUTIN_API + '/youtube/getYoutubeAccount',
    method: "get",
  })
}
export function getYoutubeCategoryId(params) {
  return request({
    // url: 'http://localhost:8567/youtube/getYoutubeCategoryId',
    url: process.env.PUTIN_API + '/youtube/getYoutubeCategoryId',
    method: "get",
    params
  })
}
export function getListMyPlaylists(params) {
  return request({
    // url: 'http://localhost:8567/youtube/getListMyPlaylists',
    url: process.env.PUTIN_API + '/youtube/getListMyPlaylists',
    method: "get",
    params
  })
}
export function getVideo(params) {
  return request({
    // url: 'http://localhost:8567/material/business/video/list',
    url: process.env.PUTIN_API + '/material/business/video/list',
    method: "get",
    params
  })
}

export function getTotalVideoNumber() {
  return request({
    // url: 'http://localhost:8567/material/business/video/total',
    url: process.env.PUTIN_API + '/material/business/video/total',
    method: 'get'
  })
}
export function uploadFromOss(data) {
  return request({
    // url: 'http://localhost:8567/youtube/uploadFromOss',
    url: process.env.PUTIN_API + '/youtube/uploadFromOss',
    method: 'post',
    data
  })
}

export function getVideoLog(params) {
  return request({
    // url: 'http://localhost:8567/youtube/getYoutubeUploadLogList',
    url: process.env.PUTIN_API + '/youtube/getYoutubeUploadLogList',
    method: 'get',
    params
  })
}


export function getVideoLogCount(params) {
    return request({
      // url: 'http://localhost:8567/youtube/getCount',
      url: process.env.PUTIN_API + '/youtube/getCount',
      method: 'get',
      params
    })
}

// 获取指定账户的转化列表
export function fetchConversionAction(data) {
  return request({
    url: process.env.PUTIN_API + '/putin/fetch/fetchConversionAction',
    method: 'POST',
    data
  })
}



export function getMaterialDirectoriesTree() {
  return request({
    // url: 'http://localhost:8567/material/business/youtube/directories/tree',
    url: process.env.PUTIN_API + '/material/business/youtube/directories/tree',
    method: 'get',
  })
}

export function fetchMaterials(params) {
  return request({
    // url: 'http://localhost:8567/material/business/youtube/getDirectoryById',
    url: process.env.PUTIN_API + '/material/business/youtube/fetchMaterials',
    method: 'get',
    params
  })
}
export function createDirectory(params) {
  return request({
    // url: 'http://localhost:8567/material/business/youtube/createdirectories',
    url: process.env.PUTIN_API + '/material/business/youtube/createdirectories',
    method: 'get',
    params
  })
}

export function updateDirectory() {
  return request({
    // url: 'http://localhost:8567/business/youtube/updateDirectory',
    url: process.env.PUTIN_API + '/business/youtube/updateDirectory',
    method: 'get',
  })
}

export function getMaterialCount(params) {
  return request({
    // url: 'http://localhost:8567/material/count',
    url: process.env.PUTIN_API + '/material/count',
    method: 'get',
    params
  })
}

export function movematerial(params) {
  return request({
    // url: 'http://localhost:8567/material/business/youtube/movematerial',
    url: process.env.PUTIN_API + '/material/business/youtube/movematerial',
    method: 'get',
    params
  })
}


export function deleteDirectory(params) {
  return request({
    // url: 'http://localhost:8567/material/business/youtube/deleteDirectory',
    url: process.env.PUTIN_API + '/material/business/youtube/deleteDirectory',
    method: 'get',
    params
  })
}

export  function uploadMaterial(body,params){
  return request({
    // url: 'http://localhost:8567/material/business/youtube/uploadVideo',
    url: process.env.PUTIN_API + '/material/business/youtube/uploadVideo',
    method: 'post',
    headers: { 'Content-Type': 'multipart/form-data' },
    data: body, // Body 数据
    params: params // 查询参数
  })
}


export function getMaterialDesigners() {
  return request({
    // url: 'http://localhost:8567/material/getMaterialDesigners',
    url: process.env.PUTIN_API + '/material/getMaterialDesigners',
    method: 'get',

  })
}
export function getMaterialsByTag(params) {
  return request({
    // url: 'http://localhost:8567/material/business/youtube/getMaterialsByTag',
    url: process.env.PUTIN_API + '/material/business/youtube/getMaterialsByTag',
    method: 'get',
    params

  })
}
export function getAllTags() {
  return request({
    // url: 'http://localhost:8567/material/getAllTags',
    url: process.env.PUTIN_API + '/material/getAllTags',
    method: 'get',

  })
}
export function getYoutubeUploadDetaillist() {
  return request({
    // url: 'http://localhost:8567/material/getYoutubeUploadDetaillist',
    url: process.env.PUTIN_API + '/material/getYoutubeUploadDetaillist',
    method: 'get',

  })
}

export function deleteMaterialById(params) {
  return request({
    // url: 'http://localhost:8567/material/getYoutubeUploadDetaillist',
    url: process.env.PUTIN_API + '/material/business/deleteMaterialById',
    method: 'post',
    params
  })
}

export function deleteYouTubeAccountById(params) {
  return request({
    // url: 'http://localhost:8567/youtube/deleteToken',
    url: process.env.PUTIN_API + '/youtube/deleteToken',
    method: 'get',
    params
  })
}


export function fetchMaterialTags() {
  return request({
    url: process.env.PUTIN_API + '/material_tags/',
    method: 'get'
  })

}


export function addMaterial(data) {
  return request({
    url: process.env.PUTIN_API + '/material/youtube/addMaterial',
    method: 'post',
    data
  })
}


export function retryUploadYoutube(params) {
  return request({
    url: process.env.PUTIN_API + '/youtube/retryUploadYoutube',
    method: 'post',
    params
  })
}

/* 通用接口 */
export function commonFetchData(params) {
  return request({
    url: process.env.BXDD_API + "/stat/common/v2/tableMapping",
    method: "get",
    params
  })
}

// ----------------------------------------

