import axios from 'axios'

// 获取所有描述组
export function getDescriptionGroupList() {
  return axios.get(process.env.PUTIN_API + '/description-groups')
    .then(response => {
      return response.data
    })
}

// 获取单个描述组
export function getDescriptionGroupById(id) {
  return axios.get(`${process.env.PUTIN_API}/description-groups/${id}`)
    .then(response => {
      return response.data
    })
}

// 创建描述组
export function createDescriptionGroup(data) {
  return axios.post(`${process.env.PUTIN_API}/description-groups`, data)
    .then(response => {
      return response.data
    })
}

// 更新描述组
export function updateDescriptionGroup(id, data) {
  return axios.put(`${process.env.PUTIN_API}/description-groups/${id}`, data)
    .then(response => {
      return response.data
    })
}

// 删除描述组
export function deleteDescriptionGroup(id) {
  return axios.delete(`${process.env.PUTIN_API}/description-groups/${id}`)
    .then(response => {
      return response.data
    })
}
