/**
 * 将data转换为Chart需要的数据类型
 * @param data
 */
export function coverDataToChart(data, labelField, datasetField, datasetLabel) {
  const colorsList = ["#F64A32", "#f87979"];
  const chartData = {};
  chartData.labels = [];
  chartData.datasets = [];
  const temp = {};
  datasetLabel.forEach(v => {
    temp[v] = [];
  });
  data.forEach(function (value, index) {
    chartData.labels.push(value[labelField]);
    datasetField.forEach(function (sv, index) {
      temp[datasetLabel[index]].push(value[sv]);
    });
  });
  Object.keys(temp).forEach(function (key, index) {
    chartData.datasets.push({
      label: key,
      data: temp[key],
      borderColor: colorsList[index]
    });
  });
  console.log(JSON.stringify(chartData));
  return chartData;
}

/**
 * 将data转换为v-Chart需要的数据类型
 * @param data
 */
export function coverDataToVChart(data, colums) {
  const chartData = {};
  chartData["columns"] = colums;
  const dataList = [];
  data.forEach(function (value, index) {
    const item = {};
    colums.forEach(function (column, index) {
      item[column] = value[column];
    });
    dataList.push(item);
  });
  return { columns: colums, rows: dataList };
}
// 利用map生成select需要的数据
export function mapToSelectData(map) {
  const dataList = [];
  for (const key in map) {
    dataList.push({ value: key, label: map[key] });
  }
  console.log(map);
  return dataList;
}

/**
 * 将"#all#"转换为文字"全部"
 * @param data
 */
export function coverAllToText(data) {
  data.forEach(function (value, index) {
    for (const key in value) {
      if (value[key] === "#all#") {
        value[key] = "全部";
      }
    }
  });
  return data;
}

/**
 *  @method
 *    获取YY-MM-DD格式的日期
 *    @param {Date} curTime 当前的格林尼治时间
 *    @return {String} YY-MM-DD 例子：2020-12-09
 */
export function getCurDateToDay(curTime) {
  var y = curTime.getFullYear();
  var m = curTime.getMonth() + 1;
  m = m < 10 ? '0' + m : m;
  var d = curTime.getDate();
  d = d < 10 ? ('0' + d) : d;
  return y + '-' + m + '-' + d;
}

/**
 *  @method
 *    获取YY-MM-DD HH:MM:SS格式的日期
 *    @param {Date} timeObj 时间对象
 *    @param {String} type 转化精确的时间段 年 月 日 时 分 秒
 *    参数：year, month, day, hour, minute, second
 *    @return {String} YY-MM-DD HH:MM:SS 例子：2020-12-09 10:22:05
 */
export function getDateToSeconds(timeObj, type) {
  var y = timeObj.getFullYear();
  var m = timeObj.getMonth() + 1;
  m = m < 10 ? '0' + m : m;
  var d = timeObj.getDate();
  d = d < 10 ? ('0' + d) : d;
  var h = timeObj.getHours(); //获取小时
  h = h < 10 ? ('0' + h) : h;
  var minute = timeObj.getMinutes(); //获取分钟
  minute = minute < 10 ? ('0' + minute) : minute;
  var s = timeObj.getSeconds(); //获取秒
  s = s < 10 ? ('0' + s) : s;
  switch (type) {
    case 'year': return y;
    case "month": return y + "-" + m;
    case "day": return y + '-' + m + '-' + d;
    case "hour": return y + '-' + m + '-' + d + " " + h;
    case 'minute': return y + '-' + m + '-' + d + " " + h + ":" + minute;
    case 'second': return y + '-' + m + '-' + d + " " + h + ":" + minute + ":" + s;
  }
  return y + '-' + m + '-' + d + " " + h + ":" + minute + ":" + s;
}

/**
 * 获取'今天'日期
 * 格式 'YY-MM-DD'
 */
export function getTime() {
  let date = new Date();
  let year = date.getFullYear();
  let month = date.getMonth() + 1;
  let day = date.getDate();
  let hour = date.getHours();
  let minute = date.getMinutes();
  let second = date.getSeconds();
  if (day < 10) {
    day = "0" + day;
  }
  if (month < 10) {
    month = "0" + month;
  }
  return year + "-" + month + "-" + day;
}

//去掉字符串两端的空格 
export function trim(str) {
  return str.replace(/(^\s*)|(\s*$)/g, "");
}
