import request from '@/utils/request'

// 获取所有素材组
export function getAllMaterialGroups() {
  return request({
    url: `${process.env.PUTIN_API}/material-groups`,
    method: 'get'
  })
}

// 根据ID获取素材组
export function getMaterialGroupById(id) {
  return request({
    url: `${process.env.PUTIN_API}/material-groups/${id}`,
    method: 'get'
  })
}

// 创建素材组
export function createMaterialGroup(data) {
  return request({
    url: `${process.env.PUTIN_API}/material-groups`,
    method: 'post',
    data
  })
}

// 更新素材组
export function updateMaterialGroup(id, data) {
  return request({
    url: `${process.env.PUTIN_API}/material-groups/${id}`,
    method: 'put',
    data
  })
}

// 删除素材组
export function deleteMaterialGroup(id) {
  return request({
    url: `${process.env.PUTIN_API}/material-groups/${id}`,
    method: 'delete'
  })
}
