import request from '@/utils/request'

export function login(account, password) {
  return request({
    url: '/user/login',
    method: 'post',
    data: {
      account,
      password
    }
  })
}

export function getInfo(token) {
  return request({
    url: '/user/info',
    method: 'get',
    params: { token }
  })
}

export function logout() {
  return request({
    url: '/user/logout',
    method: 'post'
  })
}

export function loginV2(username, password) {
  return request({
    url: process.env.BXDD_API + '/data/gateway/login',
    method: 'post',
    params: {
      username,
      password
    }
  })
}

export function getInfoV2() {
  return request({
    url: process.env.BXDD_API + '/data/gateway/user/roles',
    method: 'get',
  })
}

export function gatewayUserRouters() {
  return request({
    url: process.env.BXDD_API + "/data/gateway/user/routers?platformId=4",
    method: "get"
  });
}