import request from '@/utils/request'

/**
 * 获取账号列表
 * @param {Object} params 查询参数
 * @returns {Promise}
 */
export function getAccountList(params) {
  return request({
    url: process.env.PUTIN_API + '/oauth/accounts',
    method: 'get',
    params
  })
}

/**
 * 删除账号
 * @param {Object} data 账号信息
 * @returns {Promise}
 */
export function deleteAccount(id) {
  return request({
    url: process.env.PUTIN_API + `/oauth/google/accounts/${id}`,
    method: 'delete',
  })
}


/**
 * 获取Google授权URL
 * @returns {Promise}
 */
export function getGoogleAuthUrl() {
  return request({
    url: process.env.PUTIN_API + '/oauth/google/auth-url',
    method: 'get'
  })
}

/**
 * 获取Facebook授权URL
 * @returns {Promise}
 */
export function getFacebookAuthUrl() {
  return request({
    url: process.env.PUTIN_API + '/facebook/authorization-url',
    method: 'get'
  })
}

/**
 * 获取TikTok账户列表
 * @returns {Promise}
 */
export function getTiktokAccountList() {
  return request({
    url: process.env.PUTIN_API + '/tiktok/fbAdvertiser//fbAdvertiserList',
    method: 'get'
  })
}

/**
 * 修改账户信息
 * @param {Object} params 账户信息
 * @returns {Promise}
 */
export function updateAccount(params) {
  return request({
    url: process.env.PUTIN_API + '/tiktok/fbAdvertiser/fbAdvertiserUpdate',
    method: 'get',
    params
  })
}

/**
 * 删除TikTok账户
 * @param {Number} id 账户ID
 * @returns {Promise}
 */
export function deleteTiktokAccount(id) {
  return request({
    url: process.env.PUTIN_API + '/tiktok/fbAdvertiser/fbAdvertiserDelete',
    method: 'get',
    params: { id }
  })
}

