import request from '@/utils/request'

export function getCampaignTaskList(params) {
  return request({
    url: process.env.PUTIN_API + '/campaign-tasks',
    method: 'get',
    params
  })
}

export function getCampaignTaskById(id) {
  return request({
    url: process.env.PUTIN_API + `/campaign-tasks/${id}`,
    method: 'get'
  })
}

export function createCampaignTask(data) {
  return request({
    url: process.env.PUTIN_API + '/campaign-tasks',
    method: 'post',
    data
  })
}

export function updateCampaignTask(data) {
  return request({
    url: process.env.PUTIN_API + '/campaign-tasks',
    method: 'put',
    data
  })
}

export function deleteCampaignTask(id) {
  return request({
    url: process.env.PUTIN_API + `/campaign-tasks/${id}`,
    method: 'delete'
  })
}
