package com.base.browserwhite.utils

import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.content.pm.ShortcutInfo
import android.content.pm.ShortcutManager
import android.graphics.drawable.Icon
import android.os.Build
import com.base.browserwhite.R
import com.base.browserwhite.bean.ConstObject
import com.base.browserwhite.ui.activity.splash.Splash2Activity


object ShortcutUtils {

    /**
     * 请求创建桌面快捷方式。
     *
     * @param context     应用上下文。
     * @param shortcutId  快捷方式的唯一标识符。
     * @param shortLabel  快捷方式的简短标签。
     * @param longLabel   快捷方式的长标签。
     * @param activityClass 快捷方式要启动的Activity。
     * @param iconResId   快捷方式的图标资源ID。
     */
    fun requestCreateShortcut(
        context: Context,
        shortcutId: String?,
        shortLabel: String?,
        longLabel: String?,
        activityClass: Class<*>?,
        iconResId: Int
    ) {
        // 创建启动Activity的Intent
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.N_MR1) {
            return
        }
        val intent = Intent(context, activityClass)
        intent.setAction(Intent.ACTION_VIEW)

        // 创建ShortcutInfo实例
        val shortcut = ShortcutInfo.Builder(context, shortcutId)
            .setShortLabel(shortLabel!!)
            .setLongLabel(longLabel!!)
            .setIcon(Icon.createWithResource(context, iconResId))
            .setIntent(intent)
            .build()

        // 获取ShortcutManager实例
        val shortcutManager = context.getSystemService(Context.SHORTCUT_SERVICE) as ShortcutManager

        // 检查API级别和是否支持请求创建快捷方式
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            if (shortcutManager != null && shortcutManager.isRequestPinShortcutSupported) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    // Android 8.0及以上，直接请求创建快捷方式
                    shortcutManager.requestPinShortcut(shortcut, null)
                } else {
                    // Android 7.1 (API级别25) 使用广播接收用户响应
                    val pinnedShortcutCallbackIntent = shortcutManager.createShortcutResultIntent(shortcut)
                    val successCallback =
                        PendingIntent.getBroadcast(context, 0, Intent("com.example.SUCCESS"), PendingIntent.FLAG_UPDATE_CURRENT)
                    val failureCallback =
                        PendingIntent.getBroadcast(context, 0, Intent("com.example.FAILURE"), PendingIntent.FLAG_UPDATE_CURRENT)
                    shortcutManager.requestPinShortcut(shortcut, successCallback.intentSender)
                }
            }
        }
    }


    fun Context.addDeskShortCut() {
        //获取ShortcutManager对象

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N_MR1) {
            val shortcutManager: ShortcutManager = getSystemService(ShortcutManager::class.java) as ShortcutManager


            val shortcut1 = ShortcutInfo.Builder(this, "11111")
                .setShortLabel("Scan QR code")
                .setIcon(Icon.createWithResource(this, R.mipmap.notifi_scancode))
                .setIntent(Intent(Intent.ACTION_MAIN, null, this, Splash2Activity::class.java).apply {
                    putExtra("actionId", ConstObject.ID_SCAN_CODE)
                })
                .build()

            val shortcut2 = ShortcutInfo.Builder(this, "22222")
                .setShortLabel("Search")
                .setIcon(Icon.createWithResource(this, R.mipmap.sousuo))
                .setIntent(Intent(Intent.ACTION_MAIN, null, this, Splash2Activity::class.java))
                .build()

            val shortcut3 = ShortcutInfo.Builder(this, "33333")
                .setShortLabel("Clean Junk")
                .setIcon(Icon.createWithResource(this, R.mipmap.notifi_cleanjunk))
                .setIntent(Intent(Intent.ACTION_MAIN, null, this, Splash2Activity::class.java).apply {
                    putExtra("actionId", ConstObject.ID_JUNK_CLEANER)
                })
                .build()

            val shortcut4 = ShortcutInfo.Builder(this, "44444")
                .setShortLabel("App Process")
                .setIcon(Icon.createWithResource(this, R.mipmap.notifi_process))
                .setIntent(Intent(Intent.ACTION_MAIN, null, this, Splash2Activity::class.java).apply {
                    putExtra("actionId", ConstObject.ID_APP_PROCESS)
                })
                .build()

            //setDynamicShortcuts()方法来设置快捷方式
            shortcutManager.setDynamicShortcuts(listOf(shortcut1, shortcut2, shortcut3, shortcut4))

        }

    }
}