package com.base.browserwhite.utils

import android.app.ActivityManager
import android.content.Context


object RamUtils {
    fun Context.ramPair(): Pair<Long, Long> {
        val outInfo = ActivityManager.MemoryInfo()
        val activityManager = getSystemService(Context.ACTIVITY_SERVICE) as ActivityManager?
        activityManager!!.getMemoryInfo(outInfo)
        val totalMem = outInfo.totalMem
        val usedMem = outInfo.totalMem - outInfo.availMem
        return Pair(usedMem, totalMem)
    }
}