package com.base.browserwhite.utils

import java.text.SimpleDateFormat
import java.util.Locale

object KotlinExt {

    fun Number.toFormatSize(count: Int = 1): String {
        var suffix = "B"
        var fSize = this.toDouble()
        if (fSize > 1024) {
            suffix = "KB"
            fSize /= 1024.0
        }
        if (fSize > 1024) {
            suffix = "MB"
            fSize /= 1024.0
        }
        if (fSize > 1024) {
            suffix = "GB"
            fSize /= 1024.0
        }
        return String.format("%.${count}f %s", fSize, suffix)
    }

    fun Long.toFormatTime(): String {
        return SimpleDateFormat("MMM dd,yyyy", Locale.ENGLISH).format(this)
    }

    fun Array<String>.array2String(): String {
        val stringBuilder = StringBuilder()
        forEach {
            stringBuilder.append(it)
        }
        return stringBuilder.toString()
    }

}