package com.base.browserwhite.utils

import android.graphics.Bitmap
import android.view.View

object FragmentCacheDrawHelper {

    @Suppress("DEPRECATION")
    fun getFragmentCacheBitmap(fragmentView: View): Bitmap? {
        // 开启绘制缓存
        fragmentView.setDrawingCacheEnabled(true)
        // 获取绘制缓存的Bitmap
        val bitmap = fragmentView.drawingCache
        // 关闭和销毁绘制缓存
        fragmentView.setDrawingCacheEnabled(false)
        fragmentView.destroyDrawingCache()
        return bitmap
    }

}