package com.base.browserwhite.utils

import android.content.ClipData
import android.content.ClipboardManager
import android.content.Context
import androidx.appcompat.app.AppCompatActivity

object ClipboardUtils {

    fun Context.copyText(label: String, text: String) {
        val clipboard: ClipboardManager = getSystemService(AppCompatActivity.CLIPBOARD_SERVICE) as ClipboardManager
        // 创建一个ClipData对象，其中包含要复制的文本
//        val clip = ClipData.newPlainText("uuid", "uuid=$uuid gid=$gid")
        val clip = ClipData.newPlainText(label, text)
        // 将ClipData对象设置到剪贴板中
        clipboard.setPrimaryClip(clip)
    }

}