package com.base.browserwhite.utils

import android.content.Context
import com.base.browserwhite.MyApplication
import java.io.BufferedReader
import java.io.IOException
import java.io.InputStreamReader

object AssetUtils {

    val WebsiteJson by lazy {
        MyApplication.context.readJsonFromAsset("navigateWebsiteCfg.json")
    }

    fun Context.readJsonFromAsset(fileName: String): String {
        var json = ""
        try {
            val assetManager = this.assets
            val inputStream = assetManager.open(fileName)
            val reader = BufferedReader(InputStreamReader(inputStream))

            var line: String?
            val jsonString = StringBuilder()
            while (reader.readLine().also { line = it } != null) {
                jsonString.append(line)
            }

            reader.close()
            inputStream.close()

            json = jsonString.toString()
        } catch (e: IOException) {
            e.printStackTrace()
        }
        return json
    }
}