package com.base.browserwhite.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.base.browserwhite.MyApplication;
import java.util.Set;

public class AppPreferences {
    private static AppPreferences sInstance;
    private SharedPreferences sharedPreferences;
    private static final String PREF_FILE_NAME = "app_prefs"; // 偏好文件名

    private AppPreferences(Context context) {
        sharedPreferences = context.getSharedPreferences(PREF_FILE_NAME, Context.MODE_PRIVATE);
    }

    public static synchronized AppPreferences getInstance() {
        if (sInstance == null) {
            sInstance = new AppPreferences(MyApplication.context.getApplicationContext());
        }
        return sInstance;
    }
    // 通用 put 方法
    public  void put(String key, Object value) {
        if (value instanceof Integer) {
            sharedPreferences.edit().putInt(key, (Integer) value).apply();
        } else if (value instanceof Long) {
            sharedPreferences.edit().putLong(key, (Long) value).apply();
        } else if (value instanceof Float) {
            sharedPreferences.edit().putFloat(key, (Float) value).apply();
        } else if (value instanceof Boolean) {
            sharedPreferences.edit().putBoolean(key, (Boolean) value).apply();
        } else if (value instanceof String) {
            sharedPreferences.edit().putString(key, (String) value).apply();
        } else if (value instanceof Double){
            sharedPreferences.edit().putString(key, (String) value.toString()).apply();
        } else  if(value instanceof Set){
            sharedPreferences.edit().putStringSet(key, (Set<String>) value).apply();
        }else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass());
        }
    }

    public void put(String key, Object value, boolean isCommit) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (value instanceof Integer) {
            editor.putInt(key, (Integer) value);
        } else if (value instanceof Long) {
            editor.putLong(key, (Long) value);
        } else if (value instanceof Float) {
            editor.putFloat(key, (Float) value);
        } else if (value instanceof Boolean) {
            editor.putBoolean(key, (Boolean) value);
        } else if (value instanceof String) {
            editor.putString(key, (String) value);
        } else  if(value instanceof Set){
            sharedPreferences.edit().putStringSet(key, (Set<String>) value).apply();
        } else {
            throw new IllegalArgumentException("Unsupported type: " + value.getClass());
        }

        // 根据 isCommit 参数的值决定使用 commit() 还是 apply()
        if (isCommit) {
            editor.commit();
        } else {
            editor.apply();
        }
    }
    // 存入整数
    public void putInt(String key, int value) {
        sharedPreferences.edit().putInt(key, value).apply();
    }
    public void putStringSet(String key, Set value) {
        sharedPreferences.edit().putStringSet(key, value).apply();
    }

    public Set<String> getStringSet(String key, Set<String> defaultValue){
        return sharedPreferences.getStringSet(key, defaultValue);
    }

    // 获取整数
    public int getInt(String key, int defaultValue) {
        return sharedPreferences.getInt(key, defaultValue);
    }

    // 存入长整数
    public void putLong(String key, long value) {
        sharedPreferences.edit().putLong(key, value).apply();
    }

    // 获取长整数
    public long getLong(String key, long defaultValue) {
        return sharedPreferences.getLong(key, defaultValue);
    }

    // 存入浮点数
    public void putFloat(String key, float value) {
        sharedPreferences.edit().putFloat(key, value).apply();
    }

    // 获取浮点数
    public float getFloat(String key, float defaultValue) {
        return sharedPreferences.getFloat(key, defaultValue);
    }

    // 存入布尔值
    public void putBoolean(String key, boolean value) {
        sharedPreferences.edit().putBoolean(key, value).apply();
    }

    // 获取布尔值
    public boolean getBoolean(String key, boolean defaultValue) {
        return sharedPreferences.getBoolean(key, defaultValue);
    }

    // 存入字符串
    public void putString(String key, String value) {
        sharedPreferences.edit().putString(key, value).apply();
    }

    // 获取字符串
    public String getString(String key, String defaultValue) {
        return sharedPreferences.getString(key, defaultValue);
    }

    // 检查某个键是否存在
    public boolean contains(String key) {
        return sharedPreferences.contains(key);
    }

    // 移除某个键
    public void remove(String key) {
        sharedPreferences.edit().remove(key).apply();
    }

    // 清除所有数据
    public void clear() {
        sharedPreferences.edit().clear().apply();
    }
}