package com.base.browserwhite.utils;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.view.View;

public class AnimationUtils {

    /**
     * 开始透明度渐变动画，并设置动画结束时的回调。
     *
     * @param view        要应用动画的视图。
     * @param duration    动画持续时间（毫秒）。
     * @param endCallback 动画结束时调用的回调接口。
     */
    public static void startAlphaAnimation(final View view,
                                           long duration,
                                           final AnimationStartCallback startCallback,
                                           final AnimationEndCallback endCallback) {
        // 确保视图初始透明度为0
        view.setAlpha(0f);

        // 创建透明度从0到1的动画
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat(view, "alpha", 0f, 1f);
        alphaAnimator.setDuration(duration);

        // 设置动画监听器，以便在动画结束时调用回调
        alphaAnimator.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (startCallback != null) {
                    startCallback.onAnimationStart();
                }
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                // 调用回调接口的onAnimationEnd方法
                if (endCallback != null) {
                    endCallback.onAnimationEnd();
                }
            }
        });

        // 启动动画
        alphaAnimator.start();
    }

    /**
     * 动画结束时的回调接口。
     */
    public interface AnimationEndCallback {
        void onAnimationEnd();
    }

    /**
     * 动画结束时的回调接口。
     */
    public interface AnimationStartCallback {
        void onAnimationStart();
    }
}