package com.base.browserwhite.utils;

import android.app.Activity;

import java.util.Stack;

public class ActivityManagerUtils {

    private static ActivityManagerUtils instance;
    private Stack<Activity> activityStack = new Stack<>();

    private ActivityManagerUtils() {

    }

    public static ActivityManagerUtils getInstance() {
        if (instance == null) {
            instance = new ActivityManagerUtils();
        }
        return instance;
    }

    /**
     * 添加Activity到堆栈
     */
    public void addActivity(Activity activity) {
        activityStack.add(activity);
    }

    /**
     * 移除Activity从堆栈
     */
    public void removeActivity(Activity activity) {
        activityStack.remove(activity);
    }

    /**
     * 获取当前Activity（堆栈中最后一个压入的）
     */
    public Activity getCurrentActivity() {
        return activityStack.lastElement();
    }

    /**
     * 结束指定的Activity
     */
    public void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
        }
    }

    /**
     * 结束所有Activity
     */
    public void finishAllActivity() {
        for (Activity activity : activityStack) {
            if (activity != null) {
                activity.finish();
            }
        }
        activityStack.clear();
    }

    /**
     * 检查Activity是否存在于堆栈中
     */
    public boolean isActivityInStack(Class<?> cls) {
        boolean isExist = false;
        if (cls != null) {
            for (Activity activity : activityStack) {
                if (cls.equals(activity.getClass())) {
                    isExist = true;
                    break;
                }
            }
        }
        return isExist;
    }
    public Activity getTopActivity() {
        if (activityStack.empty()) {
            return null;
        } else {
            return activityStack.peek();
        }
    }
}