package com.base.browserwhite.ui.widget

import android.app.PendingIntent
import android.appwidget.AppWidgetManager
import android.appwidget.AppWidgetProvider
import android.content.Context
import android.content.Intent
import android.widget.RemoteViews
import com.base.browserwhite.R
import com.base.browserwhite.bean.ConstObject
import com.base.browserwhite.ui.activity.splash.Splash2Activity
import kotlin.random.Random

/**
 * Implementation of App Widget functionality.
 */
class BrowserAppWidget : AppWidgetProvider() {
    override fun onUpdate(context: Context, appWidgetManager: AppWidgetManager, appWidgetIds: IntArray) {
        // There may be multiple widgets active, so update all of them
        for (appWidgetId in appWidgetIds) {
            updateAppWidget(context, appWidgetManager, appWidgetId)
        }
    }

    override fun onEnabled(context: Context) {
        // Enter relevant functionality for when the first widget is created
    }

    override fun onDisabled(context: Context) {
        // Enter relevant functionality for when the last widget is disabled
    }
}

internal fun updateAppWidget(context: Context, appWidgetManager: AppWidgetManager, appWidgetId: Int) {
    // Construct the RemoteViews object
    val views = RemoteViews(context.packageName, R.layout.browser_app_widget)
    views.setTextViewText(R.id.tv_app_name, context.resources.getString(R.string.app_name))

    views.setTextViewText(R.id.tv_percent, "88%...")


    //清理
    val requestCode1 = Random.nextInt(1800)
    val intent1 = Intent(context, Splash2Activity::class.java).apply {
        putExtra("actionId", ConstObject.ID_JUNK_CLEANER)
    }
    val pendingIntent1 =
        PendingIntent.getActivity(context, requestCode1, intent1, PendingIntent.FLAG_IMMUTABLE)
    views.setOnClickPendingIntent(R.id.tv_clean, pendingIntent1)

    //进程
    val requestCode2 = Random.nextInt(1800)
    val intent2 = Intent(context, Splash2Activity::class.java).apply {
        putExtra("actionId", ConstObject.ID_APP_PROCESS)
    }
    val pendingIntent2 =
        PendingIntent.getActivity(context, requestCode2, intent2, PendingIntent.FLAG_IMMUTABLE)
    views.setOnClickPendingIntent(R.id.ll_process, pendingIntent2)


    //新闻
    val requestCode3 = Random.nextInt(1800)
    val intent3 = Intent(context, Splash2Activity::class.java).apply {
        putExtra("actionId", ConstObject.ID_NEWS)
    }
    val pendingIntent3 =
        PendingIntent.getActivity(context, requestCode3, intent3, PendingIntent.FLAG_IMMUTABLE)
    views.setOnClickPendingIntent(R.id.ll_news, pendingIntent3)

    //扫描
    val requestCode4 = Random.nextInt(1800)
    val intent4 = Intent(context, Splash2Activity::class.java).apply {
        putExtra("actionId", ConstObject.ID_SCAN_CODE)
    }
    val pendingIntent4 =
        PendingIntent.getActivity(context, requestCode4, intent4, PendingIntent.FLAG_IMMUTABLE)
    views.setOnClickPendingIntent(R.id.ll_scanqr, pendingIntent4)


    // Instruct the widget manager to update the widget
    appWidgetManager.updateAppWidget(appWidgetId, views)
}