package com.base.browserwhite.ui.views

import android.annotation.SuppressLint
import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.view.LayoutInflater
import android.view.View
import com.base.browserwhite.R
import com.base.browserwhite.databinding.DialogCameraPermissionAuthorizeBinding
import com.base.browserwhite.databinding.DialogPermissionStorageBottomBinding
import com.base.browserwhite.databinding.DialogPermissonOpenBinding
import com.base.browserwhite.ui.views.PermissionDialog.showPermissionBottomSheet
import com.base.browserwhite.utils.ActivityLauncher
import com.base.browserwhite.utils.PermissionUtils.requestStorePermission
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog

object PermissionDialog {
    @SuppressLint("SetTextI18n")
    fun Context.showGerPermission(
        tittle: String? = null,
        desc: String? = null,
        denyText: String? = null,
        allowText: String? = null,
        deny: ((view: Dialog) -> Unit)? = null,
        allow: ((view: Dialog) -> Unit)? = null
    ): Dialog {
        val dialog = Dialog(this)
        val binding = DialogPermissonOpenBinding.inflate(LayoutInflater.from(this))
        dialog.requestWindowFeature(1)
        dialog.window!!.setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
        dialog.window!!.setLayout(-1, -1)
        dialog.setCanceledOnTouchOutside(false)
        dialog.setCancelable(false)
        dialog.setContentView(binding.root)
        val str = resources.getString(R.string.app_name)

        tittle?.let { binding.tvTitle.text = it }
        desc?.let { binding.tvDesc.text = it }
        denyText?.let { binding.idDeny.text = it }
        allowText?.let { binding.idTvAllow.text = it }

        binding.idFullLottie.imageAssetsFolder = "permission_finger/images/"
        binding.idFullLottie.setAnimation("permission_finger/data.json")
        binding.idFullLottie.playAnimation()
        binding.idDeny.setOnClickListener {
            dialog.dismiss()
            deny?.invoke(dialog)
        }
        binding.idTvAllow.setOnClickListener {
            dialog.dismiss()
            allow?.invoke(dialog)
        }
        dialog.show()
        return dialog
    }

    @SuppressLint("SetTextI18n")
    fun Context.showPermissionBottomSheet(launcher: ActivityLauncher, agreeAction: () -> Unit) {
        val dialog = BottomSheetDialog(this, R.style.BottomSheetDialog)
        val binding = DialogPermissionStorageBottomBinding.inflate(LayoutInflater.from(this))
        dialog.setContentView(binding.root)
        dialog.setCanceledOnTouchOutside(false)

        dialog.show()

        val parentView = binding.root.parent as View
        val behavior = BottomSheetBehavior.from(parentView)
        //展开
        behavior.state = BottomSheetBehavior.STATE_EXPANDED

        val appName = resources.getString(R.string.app_name)
        binding.tvDesc.text =
            "If you want to use this feature, please first enable the storage permission of $appName in\nyour setting"

        binding.llPermission.setOnClickListener {
            dialog.dismiss()
            requestStorePermission(launcher, jumpAction = {}, result = {
                if (it) {
                    agreeAction.invoke()
                }
            })
        }
        binding.tvLater.setOnClickListener {
            dialog.dismiss()
        }
    }

    @SuppressLint("SetTextI18n")
    fun Context.showCameraAuthorize(action: () -> Unit) {
        val dialog = BottomSheetDialog(this, R.style.BottomSheetDialog)
        val binding = DialogCameraPermissionAuthorizeBinding.inflate(LayoutInflater.from(this))
        dialog.setContentView(binding.root)
        dialog.setCanceledOnTouchOutside(false)

        dialog.show()

        val parentView = binding.root.parent as View
        val behavior = BottomSheetBehavior.from(parentView)
        //展开
        behavior.state = BottomSheetBehavior.STATE_EXPANDED

        val appName = resources.getString(R.string.app_name)
        binding.tvDesc.text =
            "In order to ensure the normal use of the scanning function, $appName needs to obtain camera permissions form you."

        binding.tvAuthorize.setOnClickListener {
            dialog.dismiss()
            action.invoke()
        }
    }
}