package com.base.browserwhite.ui.views

import android.app.AlertDialog
import android.content.Context
import android.content.Intent
import android.os.Build
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import android.widget.Toast
import androidx.core.content.ContextCompat
import androidx.core.view.isVisible
import com.base.browserwhite.R
import com.base.browserwhite.bean.ConstObject
import com.base.browserwhite.bean.ConstObject.BAIDU
import com.base.browserwhite.bean.ConstObject.BING
import com.base.browserwhite.bean.ConstObject.DUCKDUCKGO
import com.base.browserwhite.bean.ConstObject.GOOGLE
import com.base.browserwhite.bean.ConstObject.YAHOO
import com.base.browserwhite.bean.ConstObject.YANDEX
import com.base.browserwhite.bean.ConstObject.searchEngineSp
import com.base.browserwhite.databinding.DialogCleanerReocordBinding
import com.base.browserwhite.databinding.DialogDefaultBrowserBinding
import com.base.browserwhite.databinding.DialogDeleteTipBinding
import com.base.browserwhite.databinding.DialogMediaMoreBinding
import com.base.browserwhite.databinding.DialogMoreWebbrowserBinding
import com.base.browserwhite.databinding.DialogMyAccountBinding
import com.base.browserwhite.databinding.DialogSearchEngineBinding
import com.base.browserwhite.help.Constants
import com.base.browserwhite.help.RxBus
import com.base.browserwhite.ui.activity.about.AboutActivity
import com.base.browserwhite.ui.activity.feedback.FeedbackActivity
import com.base.browserwhite.utils.ActivityLauncher
import com.base.browserwhite.utils.AppPreferences
import com.base.browserwhite.utils.RoleManagerUtils.isDefaultBrowser
import com.base.browserwhite.utils.RoleManagerUtils.requestRoleBrowser
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog


object DialogViews {


    fun Context.showSearchEngineDialog(confirmAction: (webSite: String) -> Unit) {

        val binding = DialogSearchEngineBinding.inflate(LayoutInflater.from(this))
        val dialog = AlertDialog.Builder(this).create()
        dialog.setView(binding.root)
        dialog.show()

        val params = dialog.window?.attributes
        params?.width = resources.getDimensionPixelOffset(R.dimen.dp_345)
//        params?.width = FrameLayout.LayoutParams.WRAP_CONTENT
        params?.height = FrameLayout.LayoutParams.WRAP_CONTENT
        dialog.window?.attributes = params
        dialog.window?.setBackgroundDrawableResource(android.R.color.transparent)

        binding.tvCancel.setOnClickListener {
            dialog.dismiss()
        }

        when (searchEngineSp) {
            GOOGLE -> binding.llGoogle.isSelected = true
            BING -> binding.llBing.isSelected = true
            YAHOO -> binding.llYahoo.isSelected = true
            DUCKDUCKGO -> binding.llDuck.isSelected = true
            YANDEX -> binding.llYandex.isSelected = true
            BAIDU -> binding.llBaidu.isSelected = true
        }

        val dismissSelect = {
            binding.llGoogle.isSelected = false
            binding.llBing.isSelected = false
            binding.llYahoo.isSelected = false
            binding.llDuck.isSelected = false
            binding.llYandex.isSelected = false
            binding.llBaidu.isSelected = false
        }

        var tempSelectWebSite = GOOGLE

        binding.llGoogle.setOnClickListener {
            dismissSelect.invoke()
            binding.llGoogle.isSelected = true
            tempSelectWebSite = GOOGLE
        }
        binding.llBing.setOnClickListener {
            dismissSelect.invoke()
            binding.llBing.isSelected = true
            tempSelectWebSite = BING
        }
        binding.llYahoo.setOnClickListener {
            dismissSelect.invoke()
            binding.llYahoo.isSelected = true
            tempSelectWebSite = YAHOO
        }
        binding.llDuck.setOnClickListener {
            dismissSelect.invoke()
            binding.llDuck.isSelected = true
            tempSelectWebSite = DUCKDUCKGO
        }
        binding.llYandex.setOnClickListener {
            dismissSelect.invoke()
            binding.llYandex.isSelected = true
            tempSelectWebSite = YANDEX
        }
        binding.llBaidu.setOnClickListener {
            dismissSelect.invoke()
            binding.llBaidu.isSelected = true
            tempSelectWebSite = BAIDU
        }

        binding.tvConfirm.setOnClickListener {
            dialog.dismiss()
            confirmAction.invoke(tempSelectWebSite)
        }

    }

    fun Context.showMyAccountDialog(launcher: ActivityLauncher) {
        val dialog = BottomSheetDialog(this, R.style.BottomSheetDialog)
        val binding = DialogMyAccountBinding.inflate(LayoutInflater.from(this))
        dialog.setContentView(binding.root)
        dialog.setCanceledOnTouchOutside(false)
        dialog.show()

        val parentView = binding.root.parent as View
        val behavior = BottomSheetBehavior.from(parentView)
        //展开
        behavior.state = BottomSheetBehavior.STATE_EXPANDED

        binding.tvId.text = AppPreferences.getInstance().getString("uuid", "")

        binding.tvSearchEngines.text = searchEngineSp
        when (searchEngineSp) {
            GOOGLE -> binding.ivSearchEngine.setImageResource(R.mipmap.m_google)
            BING -> binding.ivSearchEngine.setImageResource(R.mipmap.m_bing)
            YAHOO -> binding.ivSearchEngine.setImageResource(R.mipmap.m_yahoo)
            DUCKDUCKGO -> binding.ivSearchEngine.setImageResource(R.mipmap.m_xuckd)
            YANDEX -> binding.ivSearchEngine.setImageResource(R.mipmap.m_yandex)
            BAIDU -> binding.ivSearchEngine.setImageResource(R.mipmap.m_baidu)
        }

        binding.clSearchEngine.setOnClickListener {
            showSearchEngineDialog {
                searchEngineSp = it
                binding.tvSearchEngines.text = it
                when (searchEngineSp) {
                    GOOGLE -> binding.ivSearchEngine.setImageResource(R.mipmap.m_google)
                    BING -> binding.ivSearchEngine.setImageResource(R.mipmap.m_bing)
                    YAHOO -> binding.ivSearchEngine.setImageResource(R.mipmap.m_yahoo)
                    DUCKDUCKGO -> binding.ivSearchEngine.setImageResource(R.mipmap.m_xuckd)
                    YANDEX -> binding.ivSearchEngine.setImageResource(R.mipmap.m_yandex)
                    BAIDU -> binding.ivSearchEngine.setImageResource(R.mipmap.m_baidu)
                }
                RxBus.get().post(Constants.CHANGE_SEARCH_TYPE, searchEngineSp)
            }
        }
        binding.clDefaultBrowser.isVisible = !isDefaultBrowser()
        binding.tvSwitchBrowser.setOnCheckedChangeListener { buttonView, isChecked ->
            if (isChecked) {
                requestRoleBrowser(launcher) {
                    if (isDefaultBrowser()) {
                        binding.clDefaultBrowser.visibility = View.GONE
                    } else {
                        binding.tvSwitchBrowser.isChecked = false
                    }
                }
            }

        }
        binding.clClearRecord.setOnClickListener {
            showCleanRecordDialog()
        }
        binding.clFeedback.setOnClickListener {
            startActivity(Intent(this, FeedbackActivity::class.java))
        }
        binding.clAbout.setOnClickListener {
            startActivity(Intent(this, AboutActivity::class.java))
        }

        binding.tvCancel.setOnClickListener {
            dialog.dismiss()
        }
    }

    fun Context.showCleanRecordDialog() {
        val binding = DialogCleanerReocordBinding.inflate(LayoutInflater.from(this))
        val dialog = AlertDialog.Builder(this).create()
        dialog.setView(binding.root)
        dialog.show()

        val params = dialog.window?.attributes
        params?.width = resources.getDimensionPixelOffset(R.dimen.dp_345)
//        params?.width = FrameLayout.LayoutParams.WRAP_CONTENT
        params?.height = FrameLayout.LayoutParams.WRAP_CONTENT
        dialog.window?.attributes = params
        dialog.window?.setBackgroundDrawableResource(android.R.color.transparent)

        var cookie = false
        var searchRecord = false
        var openTab = true
        var historyRecord = true
        var cache = true

        binding.ivSelectorCookies.isSelected = cookie
        binding.ivSelectorSearchRecord.isSelected = searchRecord
        binding.ivSelectorOpenTab.isSelected = openTab
        binding.ivSelectorHistoricalRecord.isSelected = historyRecord
        binding.ivSelectorCache.isSelected = cache


        binding.ivSelectorCookies.setOnClickListener {
            it.isSelected = !it.isSelected
            cookie = it.isSelected
        }
        binding.ivSelectorSearchRecord.setOnClickListener {
            it.isSelected = !it.isSelected
            searchRecord = it.isSelected
        }
        binding.ivSelectorOpenTab.setOnClickListener {
            it.isSelected = !it.isSelected
            openTab = it.isSelected
        }
        binding.ivSelectorHistoricalRecord.setOnClickListener {
            it.isSelected = !it.isSelected
            historyRecord = it.isSelected
        }
        binding.ivSelectorCache.setOnClickListener {
            it.isSelected = !it.isSelected
            cache = it.isSelected
        }
        binding.tvCancel.setOnClickListener {
            dialog.dismiss()
        }

        binding.tvConfirm.setOnClickListener {
            dialog.dismiss()

            Toast.makeText(this, "Records have been cleared", Toast.LENGTH_SHORT).show()
        }
    }

    fun Context.showMediaMoreDialog(
        anchorView: View,
        deleteAction: () -> Unit,
        shareAction: () -> Unit,
    ) {
        val binding = DialogMediaMoreBinding.inflate(LayoutInflater.from(this))
        val dialog = AlertDialog.Builder(this).create()
        dialog.setView(binding.root)

        dialog.show()

        dialog.window?.setBackgroundDrawableResource(android.R.color.transparent)

        val params = dialog.window?.attributes
        params?.dimAmount = 0f
        params?.width = resources.getDimensionPixelOffset(R.dimen.dp_180)
//        params?.width = FrameLayout.LayoutParams.WRAP_CONTENT
        params?.height = FrameLayout.LayoutParams.WRAP_CONTENT
        params?.gravity = Gravity.TOP
        val location = IntArray(2)
        anchorView.getLocationOnScreen(location)
        params?.x = location[0]
        params?.y = location[1] - resources.getDimensionPixelOffset(R.dimen.dp_200)

        dialog.window?.attributes = params

        binding.llDelete.setOnClickListener {
            dialog.dismiss()
            deleteAction.invoke()
        }
        binding.llShare.setOnClickListener {
            dialog.dismiss()
            shareAction.invoke()
        }

    }

    fun Context.showDeleteTipDialog(desc: String? = null, action: () -> Unit) {
        val binding = DialogDeleteTipBinding.inflate(LayoutInflater.from(this))
        val dialog = AlertDialog.Builder(this).create()
        dialog.setView(binding.root)

        dialog.show()
        val params = dialog.window?.attributes
        params?.width = resources.getDimensionPixelOffset(R.dimen.dp_335)
        dialog.window?.attributes = params
        dialog.window?.setBackgroundDrawableResource(android.R.color.transparent)
        desc?.let { binding.tvDesc.text = it }
        binding.tvCancel.setOnClickListener {
            dialog.dismiss()
        }
        binding.tvDelete.setOnClickListener {
            dialog.dismiss()
            action.invoke()
        }
    }


    fun Context.showDefaultBrowserDialog(launcher: ActivityLauncher) {
        val dialog = BottomSheetDialog(this,R.style.BottomSheetDialog)
        val binding = DialogDefaultBrowserBinding.inflate(LayoutInflater.from(this))
        dialog.setContentView(binding.root)
        dialog.setCanceledOnTouchOutside(false)

        dialog.show()

        val parentView = binding.root.parent as View
        val behavior = BottomSheetBehavior.from(parentView)
        //展开
        behavior.state = BottomSheetBehavior.STATE_EXPANDED

        dialog.setOnDismissListener {
            ConstObject.isFirstMainShow = false
        }
        binding.tvLater.setOnClickListener {
            dialog.dismiss()
        }

        binding.tvBtn.setOnClickListener {
            dialog.dismiss()
            requestRoleBrowser(launcher)
        }

    }

    fun Context.showWebBrowserMoreDialog(
        bookmarkAction: (() -> Unit)? = null,//打开书签
        joinAction: (() -> Unit)? = null//加入书签
    ) {


        val dialog = BottomSheetDialog(this,R.style.BottomSheetDialog)
        val binding = DialogMoreWebbrowserBinding.inflate(LayoutInflater.from(this))
        dialog.setContentView(binding.root)
        dialog.setCanceledOnTouchOutside(false)

        dialog.show()

        val parentView = binding.root.parent as View
        val behavior = BottomSheetBehavior.from(parentView)
        //展开
        behavior.state = BottomSheetBehavior.STATE_EXPANDED

        binding.tvCancel.setOnClickListener {
            dialog.dismiss()
        }
        arrayOf(binding.ivBookmark, binding.tvBookmark).forEach {
            it.setOnClickListener {
                bookmarkAction?.invoke()
            }
        }

        arrayOf(binding.ivJoinBookmark, binding.tvJoinBookmark).forEach {
            it.setOnClickListener {
                joinAction?.invoke()
            }
        }

    }


}