package com.base.browserwhite.ui.views

import android.app.AlertDialog
import android.content.Context
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.widget.FrameLayout
import com.base.browserwhite.R
import com.base.browserwhite.databinding.DialogBookmarkMoreBinding

object BookmarkDialog {

    fun Context.showBookmarkMoreDialog(
        anchorView: View,
        isDir: Boolean,
        openNewTab: (() -> Unit)? = null,
        deleteAction: (() -> Unit)? = null,
        editAction: (() -> Unit)? = null,
        addNavAction: (() -> Unit)? = null,
        selectAction: (() -> Unit)? = null,
    ) {
        val binding = DialogBookmarkMoreBinding.inflate(LayoutInflater.from(this))
        val dialog = AlertDialog.Builder(this).create()
        dialog.setView(binding.root)

        dialog.show()

        dialog.window?.setBackgroundDrawableResource(android.R.color.transparent)

        val params = dialog.window?.attributes
        params?.dimAmount = 0f
        params?.width = resources.getDimensionPixelOffset(R.dimen.dp_250)
//        params?.width = FrameLayout.LayoutParams.WRAP_CONTENT
        params?.height = FrameLayout.LayoutParams.WRAP_CONTENT
        params?.gravity = Gravity.TOP
        val location = IntArray(2)
        anchorView.getLocationOnScreen(location)
        params?.x = resources.getDimensionPixelOffset(R.dimen.dp_100)
        params?.y = location[1] - resources.getDimensionPixelOffset(R.dimen.dp_150)
        dialog.window?.attributes = params

        if (isDir) {
            binding.llOpenNewTab.visibility = View.GONE
            binding.vOpenNewTab.visibility = View.GONE

            binding.llAddNavigation.visibility = View.GONE
            binding.vAddNavigation.visibility = View.GONE

            binding.llAddDesktop.visibility = View.GONE
            binding.vAddDesktop.visibility = View.GONE
        }

        binding.llOpenNewTab.setOnClickListener {
            dialog.dismiss()
            openNewTab?.invoke()
        }
        binding.llDelete.setOnClickListener {
            dialog.dismiss()
            deleteAction?.invoke()
        }
        binding.llEdit.setOnClickListener {
            dialog.dismiss()
            editAction?.invoke()
        }
        binding.llAddNavigation.setOnClickListener {
            dialog.dismiss()
            addNavAction?.invoke()
        }
        binding.llAddDesktop.setOnClickListener { }
        binding.llSelect.setOnClickListener {
            dialog.dismiss()
            selectAction?.invoke()
        }
    }
}