package com.base.browserwhite.ui.adapter

import android.annotation.SuppressLint
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.ViewHolder
import com.base.browserwhite.R
import com.base.browserwhite.bean.WebSiteBean
import com.base.browserwhite.bean.WebSiteGroupBean
import com.base.browserwhite.databinding.ItemWebsiteGroupBinding
import com.base.browserwhite.utils.XmlEx.inflate

class WebSiteGroupAdapter(val clickAction: (bean: WebSiteBean) -> Unit) : RecyclerView.Adapter<WebSiteGroupAdapter.GroupViewHolder>() {

    private val beanList = arrayListOf<WebSiteGroupBean>()

    inner class GroupViewHolder(view: View) : ViewHolder(view)

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): GroupViewHolder {
        return GroupViewHolder(R.layout.item_website_group.inflate(parent))
    }

    override fun getItemCount(): Int {
        return beanList.size
    }

    override fun onBindViewHolder(holder: GroupViewHolder, position: Int) {
        val binding = ItemWebsiteGroupBinding.bind(holder.itemView)
        val bean = beanList[position]
        val adapter = WebsiteAdapter(1, click = clickAction)
        binding.tvName.text = bean.category_name
        binding.rvGroup.adapter = adapter
        adapter.setData(bean.items)
    }

    @SuppressLint("NotifyDataSetChanged")
    fun setData(list: List<WebSiteGroupBean>) {
        beanList.clear()
        beanList.addAll(list)
        notifyDataSetChanged()
    }

}