package com.base.browserwhite.ui.adapter

import android.annotation.SuppressLint
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.ViewHolder
import com.base.browserwhite.R
import com.base.browserwhite.bean.ConstObject.MIME_TYPE_APK
import com.base.browserwhite.bean.ConstObject.MIME_TYPE_DOC
import com.base.browserwhite.bean.ConstObject.MIME_TYPE_DOCX
import com.base.browserwhite.bean.ConstObject.MIME_TYPE_PDF
import com.base.browserwhite.bean.ConstObject.MIME_TYPE_PPT
import com.base.browserwhite.bean.ConstObject.MIME_TYPE_PPTX
import com.base.browserwhite.bean.ConstObject.MIME_TYPE_XLS
import com.base.browserwhite.bean.ConstObject.MIME_TYPE_XLSX
import com.base.browserwhite.bean.ConstObject.MIME_TYPE_ZIP
import com.base.browserwhite.bean.MediaBean
import com.base.browserwhite.databinding.ItemMediaListBinding
import com.base.browserwhite.databinding.ItemMediaPictureVideoBinding
import com.base.browserwhite.databinding.ItemMediaRecentBinding
import com.base.browserwhite.utils.KotlinExt.toFormatSize
import com.base.browserwhite.utils.XmlEx.inflate
import com.bumptech.glide.Glide
import java.io.File

class MediaAdapter(
    val uiType: Int,
    val clickAction: ((bean: MediaBean) -> Unit)? = null,
    val moreAction: ((view: View, bean: MediaBean) -> Unit)? = null
) : RecyclerView.Adapter<MediaAdapter.MediaViewHolder>() {

     val beanList = arrayListOf<MediaBean>()

    inner class MediaViewHolder(view: View) : ViewHolder(view)

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): MediaViewHolder {
        if (uiType == 0) {
            return MediaViewHolder(R.layout.item_media_recent.inflate(parent))
        }
        if (uiType == 1) {
            return MediaViewHolder(R.layout.item_media_picture_video.inflate(parent))
        }
        if (uiType == 2) {
            return MediaViewHolder(R.layout.item_media_list.inflate(parent))
        }
        return MediaViewHolder(R.layout.item_media_recent.inflate(parent))
    }

    override fun getItemCount(): Int {
        return beanList.size
    }

    override fun onBindViewHolder(holder: MediaViewHolder, position: Int) {


        val context = holder.itemView.context
        val bean = beanList[position]

        if (uiType == 0) {
            val binding = ItemMediaRecentBinding.bind(holder.itemView)
            binding.ivShipin.visibility = View.GONE
            when {
                bean.mimeType.contains("image") -> {
                    Glide.with(context).load(bean.path).into(binding.iv)
                }

                bean.mimeType.contains("video") -> {
                    Glide.with(context).load(bean.path).into(binding.iv)
                    binding.ivShipin.visibility = View.VISIBLE
                }

                bean.mimeType.contains("audio") -> {
                    binding.iv.setImageResource(R.mipmap.z_music)
                }

                bean.mimeType == MIME_TYPE_PDF -> {
                    binding.iv.setImageResource(R.mipmap.f_pdf)
                }

                bean.mimeType == MIME_TYPE_DOC || bean.mimeType == MIME_TYPE_DOCX -> {
                    binding.iv.setImageResource(R.mipmap.h_word)
                }

                bean.mimeType == MIME_TYPE_XLS || bean.mimeType == MIME_TYPE_XLSX -> {
                    binding.iv.setImageResource(R.mipmap.h_xls)
                }

                bean.mimeType == MIME_TYPE_PPT || bean.mimeType == MIME_TYPE_PPTX -> {
                    binding.iv.setImageResource(R.mipmap.h_ppt)
                }

                bean.mimeType == MIME_TYPE_APK -> {
                    binding.iv.setImageResource(R.mipmap.h_apk)
                }

                bean.mimeType == MIME_TYPE_ZIP -> {
                    binding.iv.setImageResource(R.mipmap.z_zip)
                }
            }

            val file = File(bean.path)
            binding.tvName.text = file.name
            binding.tvSize.text = file.length().toFormatSize()

            binding.flMore.setOnClickListener {
                moreAction?.invoke(it, bean)
            }
            binding.root.setOnClickListener {
                clickAction?.invoke(bean)
            }
        } else if (uiType == 1) {
            val binding = ItemMediaPictureVideoBinding.bind(holder.itemView)
            Glide.with(context).load(bean.path).centerCrop().into(binding.iv)
            binding.root.setOnClickListener {
                clickAction?.invoke(bean)
            }
            if (bean.mimeType.contains("video")) {
                binding.ivShipin.visibility = View.VISIBLE
            }
        } else if (uiType == 2) {
            val binding = ItemMediaListBinding.bind(holder.itemView)
            when {
                bean.mimeType.contains("image") -> {
                    Glide.with(context).load(bean.path).into(binding.iv)
                }

                bean.mimeType.contains("video") -> {
                    Glide.with(context).load(bean.path).into(binding.iv)
                    binding.ivShipin.visibility = View.VISIBLE
                }

                bean.mimeType.contains("audio") -> {
                    binding.iv.setImageResource(R.mipmap.z_music)
                }

                bean.mimeType == MIME_TYPE_PDF -> {
                    binding.iv.setImageResource(R.mipmap.f_pdf)
                }

                bean.mimeType == MIME_TYPE_DOC || bean.mimeType == MIME_TYPE_DOCX -> {
                    binding.iv.setImageResource(R.mipmap.h_word)
                }

                bean.mimeType == MIME_TYPE_XLS || bean.mimeType == MIME_TYPE_XLSX -> {
                    binding.iv.setImageResource(R.mipmap.h_xls)
                }

                bean.mimeType == MIME_TYPE_PPT || bean.mimeType == MIME_TYPE_PPTX -> {
                    binding.iv.setImageResource(R.mipmap.h_ppt)
                }

                bean.mimeType == MIME_TYPE_APK -> {
                    binding.iv.setImageResource(R.mipmap.h_apk)
                }

                bean.mimeType == MIME_TYPE_ZIP -> {
                    binding.iv.setImageResource(R.mipmap.z_zip)
                }
            }
            val file = File(bean.path)
            binding.tvName.text = file.name
            binding.tvSize.text = file.length().toFormatSize()

            binding.flMore.setOnClickListener {
                moreAction?.invoke(it, bean)
            }
            binding.root.setOnClickListener {
                clickAction?.invoke(bean)
            }
        }

    }

    @SuppressLint("NotifyDataSetChanged")
    fun setData(mediaList: List<MediaBean>) {
        beanList.clear()
        beanList.addAll(mediaList)
        notifyDataSetChanged()
    }

    fun removeData(bean: MediaBean) {
        val index = beanList.indexOf(bean)
        beanList.remove(bean)
        notifyItemRemoved(index)
    }
}