package com.base.browserwhite.ui.adapter

import android.annotation.SuppressLint
import android.view.ViewGroup
import android.view.animation.AnimationUtils
import com.base.browserwhite.R
import com.base.browserwhite.bean.ParentBean
import com.base.browserwhite.databinding.ItemJunkChildBinding
import com.base.browserwhite.databinding.ItemJunkParentBinding
import com.base.browserwhite.utils.KotlinExt.toFormatSize
import com.base.browserwhite.utils.XmlEx.inflate
import pokercc.android.expandablerecyclerview.ExpandableAdapter
import java.io.File

class JunkExpandAdapter(private val selectAction: (size: Long) -> Unit) : ExpandableAdapter<ExpandableAdapter.ViewHolder>() {

    private val beanList = arrayListOf<ParentBean>()
    override fun getChildCount(groupPosition: Int): Int {
        return beanList[groupPosition].childItem.size
    }

    override fun getGroupCount(): Int {
        return beanList.size
    }

    override fun onCreateChildViewHolder(viewGroup: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(R.layout.item_junk_child.inflate(viewGroup))
    }

    override fun onCreateGroupViewHolder(viewGroup: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(R.layout.item_junk_parent.inflate(viewGroup))
    }

    override fun onBindChildViewHolder(holder: ViewHolder, groupPosition: Int, childPosition: Int, payloads: List<Any>) {
        val binding = ItemJunkChildBinding.bind(holder.itemView)
        val parentBean = beanList[groupPosition]
        val childBeanList = parentBean.childItem
        val childBean = childBeanList[childPosition]
        if (payloads.isEmpty()) {
            if (childBean.apkIcon == null) binding.iv.setImageResource(childBean.icon) else binding.iv.setImageDrawable(childBean.apkIcon)
            val file = File(childBean.path)
            binding.tvName.text = file.name
            binding.tvSize.text = file.length().toFormatSize()
            binding.ivSelector.isSelected = childBean.isSelect
            binding.root.setOnClickListener {
                childBean.isSelect = !childBean.isSelect
                notifyChildChange(groupPosition, childPosition, "aaa")
                val allSelect = childBeanList.all { it.isSelect }
                if (parentBean.isSelect != allSelect) {
                    parentBean.isSelect = allSelect
                    notifyGroupChange(groupPosition, "aa")
                }
                selectChange()
            }

            if (childBean.playAnimation) {
                val slideInFromRight = AnimationUtils.loadAnimation(holder.itemView.context, R.anim.slide_in_from_right)
                binding.root.startAnimation(slideInFromRight)
                childBean.playAnimation = false
            }

        } else {
            binding.ivSelector.isSelected = childBean.isSelect
        }
    }

    @SuppressLint("NotifyDataSetChanged")
    override fun onBindGroupViewHolder(holder: ViewHolder, groupPosition: Int, expand: Boolean, payloads: List<Any>) {

        val binding = ItemJunkParentBinding.bind(holder.itemView)
        val bean = beanList[groupPosition]
        bean.isExpand = expand
        if (bean.isExpand) {
            binding.ivExpand.setImageResource(R.mipmap.zhankai)
        } else {
            binding.ivExpand.setImageResource(R.mipmap.shouqi)
        }

        if (payloads.isEmpty()) {
            binding.tvName.text = bean.tittle
            val size = bean.childItem.sumOf { File(it.path).length() }
            binding.tvSize.text = size.toFormatSize()
            binding.flExpand.setOnClickListener {
                bean.isExpand = !bean.isExpand
                notifyGroupChange(groupPosition, "aa")
                if (bean.isExpand) {
                    expandGroup(groupPosition, true)
                } else {
                    collapseGroup(groupPosition, true)
                }
            }
            binding.ivSelector.isSelected = bean.isSelect
            binding.flSelector.setOnClickListener {
                bean.isSelect = !bean.isSelect
                bean.childItem.forEach { it.isSelect = bean.isSelect }
                notifyDataSetChanged()
                selectChange()
            }
            if (bean.playAnimation) {
                val slideInFromRight = AnimationUtils.loadAnimation(holder.itemView.context, R.anim.slide_in_from_right)
                binding.root.startAnimation(slideInFromRight)
                bean.playAnimation = false
            }
        } else {
            binding.ivSelector.isSelected = bean.isSelect
        }

    }

    override fun onGroupViewHolderExpandChange(holder: ViewHolder, groupPosition: Int, animDuration: Long, expand: Boolean) {}

    @SuppressLint("NotifyDataSetChanged")
    fun addData(list: List<ParentBean>, clear: Boolean = true) {
        if (clear) {
            beanList.clear()
        }
        beanList.addAll(list)
        notifyDataSetChanged()
    }

    private fun selectChange() {
        val size = beanList.flatMap { it.childItem }.filter { it.isSelect }.sumOf { bean -> File(bean.path).length() }
        selectAction.invoke(size)
    }

    fun getChoosePath(): List<String> {
        return beanList.flatMap { it.childItem }.filter { it.isSelect }.map { it.path }
    }
}
