package com.base.browserwhite.ui.adapter

import android.content.Context
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.base.browserwhite.R
import com.base.browserwhite.bean.ConstObject.APP_PROCESS
import com.base.browserwhite.bean.ConstObject.BOOKMARK
import com.base.browserwhite.bean.ConstObject.JUNK_CLEANER
import com.base.browserwhite.bean.ConstObject.NEWS
import com.base.browserwhite.databinding.ItemHead1Binding
import com.base.browserwhite.utils.XmlEx.inflate
import com.chad.library.adapter4.BaseSingleItemAdapter

class HeaderAdapter(val click: (key: String) -> Unit) : BaseSingleItemAdapter<Any, HeaderAdapter.VH>() {

    class VH(view: View) : RecyclerView.ViewHolder(view)

    override fun onBindViewHolder(holder: VH, item: Any?) {
        val binding = ItemHead1Binding.bind(holder.itemView)
        binding.llClean.setOnClickListener {
            click.invoke(JUNK_CLEANER)
        }
        binding.llNews.setOnClickListener {
            click.invoke(NEWS)
        }
        binding.llProcess.setOnClickListener {
            click.invoke(APP_PROCESS)
        }
        binding.llBookmark.setOnClickListener {
            click.invoke(BOOKMARK)
        }
    }

    override fun onCreateViewHolder(context: Context, parent: ViewGroup, viewType: Int): VH {
        return VH(R.layout.item_head_1.inflate(parent))
    }
}