package com.base.browserwhite.ui.adapter

import android.content.Context
import android.content.Intent
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.ItemTouchHelper
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.base.browserwhite.R
import com.base.browserwhite.bean.WebSiteBean
import com.base.browserwhite.databinding.ItemWebsiteHeadBinding
import com.base.browserwhite.ui.activity.webbrowser.WebBrowserActivity
import com.base.browserwhite.ui.activity.webstore.WebStoreActivity
import com.base.browserwhite.ui.views.itemtouch.MyItemTouchHelperCallBack
import com.base.browserwhite.utils.XmlEx.inflate
import com.chad.library.adapter4.BaseSingleItemAdapter

class HeadWebsiteAdapter : BaseSingleItemAdapter<List<WebSiteBean>, HeadWebsiteAdapter.VH>() {

    inner class VH(view: View) : RecyclerView.ViewHolder(view)

    var flag = false
    override fun onBindViewHolder(holder: VH, item: List<WebSiteBean>?) {
        if (flag) {
            return
        }
        flag = true
        val binding = ItemWebsiteHeadBinding.bind(holder.itemView)
        val context = holder.itemView.context
        binding.rvWebsite.layoutManager = GridLayoutManager(context, 4, LinearLayoutManager.VERTICAL, false)

        val websiteAdapter = WebsiteAdapter(0) { bean ->
            if (bean.name == "Increase") {
                context.startActivity(Intent(context, WebStoreActivity::class.java))
            } else {
                context.startActivity(Intent(context, WebBrowserActivity::class.java).apply {
                    putExtra("url", bean.url)
                })
            }
        }
        binding.rvWebsite.adapter = websiteAdapter
        val itemTouchHelper = ItemTouchHelper(MyItemTouchHelperCallBack())
        itemTouchHelper.attachToRecyclerView(binding.rvWebsite)
        websiteAdapter.setData(item)
    }

    override fun onCreateViewHolder(context: Context, parent: ViewGroup, viewType: Int): VH {
        return VH(R.layout.item_website_head.inflate(parent))
    }


}