package com.base.browserwhite.ui.activity.webstore

import android.annotation.SuppressLint
import android.content.Intent
import android.graphics.Color
import android.graphics.drawable.Drawable
import androidx.activity.addCallback
import androidx.core.view.updatePadding
import androidx.lifecycle.lifecycleScope
import com.base.browserwhite.R
import com.base.browserwhite.ads.AdmobMaxHelper
import com.base.browserwhite.ads.AdmobMaxHelper.lastShowInter
import com.base.browserwhite.bean.WebCategoryBean
import com.base.browserwhite.bean.WebSiteGroupBean
import com.base.browserwhite.bean.webCategoryBeanList
import com.base.browserwhite.bean.webSiteGroupBeanList
import com.base.browserwhite.databinding.ActivityWebStoreBinding
import com.base.browserwhite.databinding.ItemTabWebstoreBinding
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.ui.activity.webbrowser.WebBrowserActivity
import com.base.browserwhite.ui.adapter.WebSiteGroupAdapter
import com.base.browserwhite.utils.BarUtils
import com.base.browserwhite.utils.LogEx
import com.bumptech.glide.Glide
import com.bumptech.glide.request.target.CustomTarget
import com.bumptech.glide.request.transition.Transition
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch


class WebStoreActivity : BaseActivity<ActivityWebStoreBinding>() {

    private val TAG = "WevStoreActivity"

    override val binding: ActivityWebStoreBinding by lazy {
        ActivityWebStoreBinding.inflate(layoutInflater)
    }
    private val webCategoryBean: ArrayList<WebCategoryBean> = arrayListOf()
    private val webSiteGroupBean: ArrayList<WebSiteGroupBean> = arrayListOf()
    private lateinit var adapter: WebSiteGroupAdapter

    @SuppressLint("SetTextI18n")
    override fun initView() {
        BarUtils.setStatusBarLightMode(this, true)
        BarUtils.setStatusBarColor(this, Color.TRANSPARENT)
        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())

        adapter = WebSiteGroupAdapter(clickAction = { bean ->
            startActivity(Intent(this, WebBrowserActivity::class.java).apply {
                putExtra("url", bean.url)
                putExtra("from", "WevStoreActivity")

            })
            finish()
        })
        binding.rv.adapter = adapter
        binding.tabLayout.observeIndexChange { fromIndex, toIndex, reselect, fromUser ->
            if (!reselect) {
                binding.rv.smoothScrollToPosition(toIndex)
            }
        }

        initData()
    }

    override fun initListener() {
        super.initListener()

        onBackPressedDispatcher.addCallback {
            if (System.currentTimeMillis() - lastShowInter > 10 * 1000 * 1000 || lastShowInter == 0L) {
                AdmobMaxHelper.admobMaxShowInterstitialAd(this@WebStoreActivity, false) {
                    if (it) {
                        lastShowInter = System.currentTimeMillis()
                    }
                    finishToMain()
                }
            }else{
                finishToMain()
            }
        }
        binding.ivGuanbi.setOnClickListener {
            onBackPressedDispatcher.onBackPressed()
        }
    }

    private fun initData() = lifecycleScope.launch(Dispatchers.IO) {
        webCategoryBean.addAll(webCategoryBeanList)
        webSiteGroupBean.addAll(webSiteGroupBeanList)

        val imageSize = this@WebStoreActivity.resources.getDimensionPixelSize(R.dimen.dp_26)
        launch(Dispatchers.Main) {
            webCategoryBean.forEach { bean ->
//                LogEx.logDebug(TAG, bean.iconUrl)
                val tabBinding = ItemTabWebstoreBinding.inflate(layoutInflater)
                tabBinding.tv.text = bean.name

                Glide.with(this@WebStoreActivity).asDrawable().load(bean.iconUrl).into(
                    object : CustomTarget<Drawable>() {
                        override fun onResourceReady(resource: Drawable, transition: Transition<in Drawable>?) {
                            LogEx.logDebug(TAG, "resource=${resource.intrinsicWidth} ${resource.intrinsicHeight}")
                            /// 这一步必须要做,否则不会显示.
                            resource.setBounds(0, 0, imageSize, imageSize)

                            // 设置TextView的左侧图标
                            tabBinding.tv.setCompoundDrawables(resource, null, null, null)

                            // 设置图片与文本之间的间距
                            val padding = 10 // 例如10dp的间距
                            tabBinding.tv.setCompoundDrawablePadding(padding)
                        }

                        override fun onLoadCleared(placeholder: Drawable?) {
                        }

                    }
                )
                binding.tabLayout.addView(tabBinding.root)
            }

            adapter.setData(webSiteGroupBeanList)
        }

    }

}