package com.base.browserwhite.ui.activity.weather

import android.annotation.SuppressLint
import android.graphics.Color
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.activity.OnBackPressedCallback
import androidx.core.view.isVisible
import androidx.core.view.updatePadding
import androidx.recyclerview.widget.RecyclerView
import com.base.browserwhite.R
import com.base.browserwhite.ads.AdmobMaxHelper
import com.base.browserwhite.bean.ListBean
import com.base.browserwhite.bean.WeatherBean
import com.base.browserwhite.databinding.ActivityWeatherBinding
import com.base.browserwhite.help.WeatherUtils
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.utils.BarUtils
import kotlin.random.Random

@SuppressLint("SimpleDateFormat")
class WeatherInterface : BaseActivity<ActivityWeatherBinding>() {
    override val binding: ActivityWeatherBinding by lazy {
        ActivityWeatherBinding.inflate(layoutInflater)
    }
    var wBean: WeatherBean? = null
    override fun initView() {
        BarUtils.setStatusBarColor(this, Color.TRANSPARENT)
        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())
        getData()

        AdmobMaxHelper.admobMaxShowNativeAd(this, binding.idFlAd)

    }

    override fun initListener() {
        binding.idBack.setOnClickListener {
            onBackPressedDispatcher.onBackPressed()
        }
        onBackPressedDispatcher.addCallback(object : OnBackPressedCallback(true) {
            override fun handleOnBackPressed() {
                finishToMain()
            }
        })
    }

    private fun getData() {

        wBean = WeatherUtils.getWeatherEntity()
        if (wBean != null) {
            setViews()
        } else {
            WeatherUtils.requestWeatherData()
        }
        binding.root.postDelayed({
            AdmobMaxHelper.admobMaxShowInterstitialAd(this, false) {
                binding.idFlLoading.isVisible = false
            }
        }, Random.nextLong(800, 2000))

    }


    @SuppressLint("SetTextI18n")
    private var wertherList = mutableListOf<ListBean>()
    private fun setViews() {
        binding.idTvCity.text = wBean?.city
        binding.idTvDate.text = wBean?.list?.get(0)?.fxDate
        binding.idTvTmp.text = "${wBean?.list?.get(0)?.tempMax}°"
        binding.idTvHumidity.text = "${wBean?.list?.get(0)?.humidity}%"
        binding.idTvWind.text = "${wBean?.list?.get(0)?.windScaleDay}"
        binding.idTvPressure.text = "${wBean?.list?.get(0)?.pressure}hPa"
        when (WeatherUtils.getWeatherType((wBean?.list?.get(0)?.iconDay)!!.toInt())) {
            "Sunny day" -> {
                binding.idImgW.setImageResource(R.mipmap.d_qing)
            }

            "Cloudy day" -> {
                binding.idImgW.setImageResource(R.mipmap.d_yin)
            }

            "Rainy day" -> {
                binding.idImgW.setImageResource(R.mipmap.d_dayu)
            }

            "Snowy day" -> {
                binding.idImgW.setImageResource(R.mipmap.d_xiaxue)
            }

            "Greasy day" -> {
                binding.idImgW.setImageResource(R.mipmap.d_wumaishachengbao)
            }

            "Unknown" -> {
                binding.idImgW.setImageResource(R.mipmap.d_qing)
            }
        }

        wertherList.clear()
        wBean?.list?.let { wertherList.addAll(it) }
        binding.idRlWeather.run {
            adapter = object : RecyclerView.Adapter<ViewHolder>() {
                override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
                    val view = LayoutInflater.from(this@WeatherInterface)
                        .inflate(R.layout.item_layout_wheather, parent, false)
                    return ViewHolder(view)
                }

                override fun getItemCount(): Int {
                    return wertherList.size
                }

                @SuppressLint("SetTextI18n")
                override fun onBindViewHolder(holder: ViewHolder, position: Int) {
                    val item = wertherList[position]
                    when (WeatherUtils.getWeatherType(item.iconDay.toInt())) {
                        "Sunny day" -> {
                            holder.ivIcon.setImageResource(R.mipmap.x_qing)
                        }

                        "Cloudy day" -> {
                            holder.ivIcon.setImageResource(R.mipmap.x_yin)
                        }

                        "Rainy day" -> {
                            holder.ivIcon.setImageResource(R.mipmap.x_dayu)
                        }

                        "Snowy day" -> {
                            holder.ivIcon.setImageResource(R.mipmap.x_xiaxue)
                        }

                        "Greasy day" -> {
                            holder.ivIcon.setImageResource(R.mipmap.x_wumaishachengbao)
                        }

                        "Unknown" -> {
                            holder.ivIcon.setImageResource(R.mipmap.x_qing)
                        }
                    }

                    holder.tvTime.text = item.fxDate
                    holder.tvMaxTmp.text = "${item.tempMax}°/"
                    holder.tvMinTmp.text = "${item.tempMin}°"
                }

            }
        }
    }

    inner class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        val ivIcon: ImageView
        val tvTime: TextView
        val tvMaxTmp: TextView
        val tvMinTmp: TextView

        init {
            ivIcon = view.findViewById(R.id.id_img_icon)
            tvTime = view.findViewById(R.id.id_tv_time)
            tvMaxTmp = view.findViewById(R.id.id_tv_max_tmp)
            tvMinTmp = view.findViewById(R.id.id_tv_min_tmp)
        }
    }

}
