package com.base.browserwhite.ui.activity.splash

import android.app.Activity
import android.content.Intent
import android.util.Log
import com.base.browserwhite.bean.ConstObject.ID_APP_PROCESS
import com.base.browserwhite.bean.ConstObject.ID_JUNK_CLEANER
import com.base.browserwhite.bean.ConstObject.ID_NEWS
import com.base.browserwhite.bean.ConstObject.ID_SCAN_CODE
import com.base.browserwhite.ui.activity.MainActivity
import com.base.browserwhite.ui.activity.appprocess.AppProcessActivity
import com.base.browserwhite.ui.activity.cleanjunk.ScanJunkActivity
import com.base.browserwhite.ui.activity.news.NewsActivity
import com.base.browserwhite.ui.activity.scanqrc.ScanQRCActivity
import com.base.browserwhite.utils.PermissionUtils.checkCameraPermission

object StartUtils {

    private val TAG = "SplashJumpUtils"
    fun jumpNextPage(context: Activity) {

        var jumpType = context.intent.getIntExtra("actionId", 0)

        Log.e(TAG, "actionId: $jumpType")

        if (jumpType == 0) {
            val uri = context.intent.data
            val str = (uri?.getQueryParameter("type") ?: "0")
            jumpType = str.toIntOrNull() ?: 0
            if (jumpType != 0) {
            }
        }
        when (jumpType) {
            ID_JUNK_CLEANER -> {
                if (context.checkCameraPermission()) {
                    context.startActivity(Intent(context, ScanJunkActivity::class.java))
                } else {
                    context.startActivity(Intent(context, MainActivity::class.java).apply {
                        putExtra("cleanAskPermission",true)
                    })
                }
            }

            ID_NEWS -> {
                context.startActivity(Intent(context, NewsActivity::class.java))
            }

            ID_SCAN_CODE -> {
                context.startActivity(Intent(context, ScanQRCActivity::class.java))
            }

            ID_APP_PROCESS -> {
                context.startActivity(Intent(context, AppProcessActivity::class.java))
            }

            else -> {
                val isHotLaunch = context.intent?.extras?.getBoolean("isHotLaunch", false) ?: false
                if (!isHotLaunch) {

                    context.startActivity(Intent(context, MainActivity::class.java))

                }
            }
        }
        context.finish()
    }
}