package com.base.browserwhite.ui.activity.splash

import android.app.Activity
import android.content.Intent
import android.net.Uri
import android.text.SpannableString
import android.text.Spanned
import android.text.style.UnderlineSpan
import android.view.View
import com.base.browserwhite.MyApplication
import com.base.browserwhite.bean.ConstObject.ifAgreePrivacy
import com.base.browserwhite.databinding.ActivitySplash2Binding
import com.base.browserwhite.help.ConfigHelper


class PrivacyManager {


    private val binding: ActivitySplash2Binding

    private val context: Activity

    private val listener: onUserPrivacyAggreementListener

    constructor(
        binding: ActivitySplash2Binding,
        context: Activity,
        listener: onUserPrivacyAggreementListener
    ) {
        this.binding = binding
        this.context = context
        this.listener = listener
        initView()
    }


    private fun initView() {


        val spannableString = SpannableString("Privacy Policy")
        spannableString.setSpan(
            UnderlineSpan(),
            0,
            spannableString.length,
            Spanned.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        binding.idTvPrivacyPolicy.text = spannableString

        binding.idTvPrivacyPolicy.setOnClickListener {
            val intent = Intent(
                Intent.ACTION_VIEW,
                Uri.parse(ConfigHelper.privacyPolicy)
            )
            context.startActivity(intent)
        }

        var clicked = false
        binding.idTvStart.setOnClickListener {
            if (clicked) {
                return@setOnClickListener
            }
            clicked = true
            ifAgreePrivacy = true
            (context.application as MyApplication).initApp()
            listener.onAgreePrivacy(true)
        }
    }

    interface onUserPrivacyAggreementListener {
        fun onAgreePrivacy(isStart: Boolean=false)
    }

}