package com.base.browserwhite.ui.activity.search

import android.content.Context
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView.ViewHolder
import com.base.browserwhite.R
import com.base.browserwhite.databinding.ItemSearchTipBinding
import com.base.browserwhite.utils.XmlEx.inflate
import com.chad.library.adapter4.BaseQuickAdapter

class SearchAdapter : BaseQuickAdapter<String, SearchAdapter.SearchViewHolder>() {
    inner class SearchViewHolder(view: View) : ViewHolder(view)

    var searchAction: ((content: String) -> Unit)? = null

    override fun onBindViewHolder(holder: SearchViewHolder, position: Int, item: String?) {
        if (item == null) return
        val binding = ItemSearchTipBinding.bind(holder.itemView)
        binding.tvTip.text = item
        binding.root.setOnClickListener {
            searchAction?.invoke(item)
        }
    }

    override fun onCreateViewHolder(context: Context, parent: ViewGroup, viewType: Int): SearchViewHolder {
        return SearchViewHolder(R.layout.item_search_tip.inflate(parent))
    }
}