package com.base.browserwhite.ui.activity.scanqrc

import android.content.Intent
import android.graphics.Color
import android.view.View
import android.widget.Toast
import androidx.activity.addCallback
import androidx.core.view.updatePadding
import com.base.browserwhite.ads.AdmobMaxHelper
import com.base.browserwhite.ads.admob.AdmobNativeUtils
import com.base.browserwhite.bean.ConstObject.searchEngineSp
import com.base.browserwhite.databinding.ActivityQrcResultBinding
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.ui.activity.webbrowser.WebBrowserActivity
import com.base.browserwhite.utils.BarUtils
import com.base.browserwhite.utils.ClipboardUtils.copyText
import com.base.browserwhite.utils.LinkSearchUtils
import com.base.browserwhite.utils.LinkSearchUtils.getSearchUrl

class QrcResultActivity : BaseActivity<ActivityQrcResultBinding>() {

    override val binding: ActivityQrcResultBinding by lazy {
        ActivityQrcResultBinding.inflate(layoutInflater)
    }

    private var qrCodeValue: String? = null
    override fun initView() {
        BarUtils.setStatusBarLightMode(this, true)
        BarUtils.setStatusBarColor(this, Color.WHITE)
        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())

        qrCodeValue = intent.extras?.getString("qrCodeValue")
        binding.tvQrcodevalue.text = qrCodeValue

        AdmobMaxHelper.admobMaxShowNativeAd(this, binding.flAd, "QrcResultActivity")
        AdmobNativeUtils.onAdLoaded = {
            binding.line2.visibility = View.VISIBLE
        }
    }

    override fun initListener() {
        super.initListener()
        onBackPressedDispatcher.addCallback {
            finishToMain()
        }
        binding.flFanhui.setOnClickListener {
            onBackPressedDispatcher.onBackPressed()
        }

        binding.llCopy.setOnClickListener {
            copyText("qrCodeValue", qrCodeValue ?: "")
            Toast.makeText(this, "copy to clipboard", Toast.LENGTH_SHORT).show()
        }
        binding.llSearch.setOnClickListener {
            LinkSearchUtils.handleInput(qrCodeValue ?: "",
                loadUrl = { url ->
                    startActivity(Intent(this, WebBrowserActivity::class.java).apply {
                        putExtra("url", url)
                        putExtra("searchEngine", searchEngineSp)
                    })
                },
                performSearch = { search ->
                    startActivity(Intent(this, WebBrowserActivity::class.java).apply {
                        putExtra("url", getSearchUrl(search))
                        putExtra("searchEngine", searchEngineSp)
                    })
                })
        }
        binding.llShare.setOnClickListener {
            try {
                val shareIntent = Intent(Intent.ACTION_SEND)
                shareIntent.setType("text/plain")
                shareIntent.putExtra(Intent.EXTRA_TEXT, qrCodeValue)
                startActivity(Intent.createChooser(shareIntent, "share text"))
            } catch (e: Exception) {
                Toast.makeText(this, "no app can show", Toast.LENGTH_SHORT).show()
            }

        }

    }

}