package com.base.browserwhite.ui.activity.result

import android.annotation.SuppressLint
import android.content.Intent
import android.graphics.Color
import androidx.activity.addCallback
import com.base.browserwhite.bean.ConstObject.APP_PROCESS
import com.base.browserwhite.bean.ConstObject.JUNK_CLEANER
import com.base.browserwhite.databinding.ActivityResultBinding
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.ui.activity.news.NewsDetailActivity
import com.base.browserwhite.ui.adapter.NewsAdapter
import com.base.browserwhite.utils.BarUtils
import com.base.browserwhite.utils.KotlinExt.toFormatSize
import com.base.browserwhite.utils.LogEx
import com.base.browserwhite.help.NewsUtils
import com.base.browserwhite.ui.activity.appprocess.AppProcessActivity
import com.chad.library.adapter4.QuickAdapterHelper
import com.chad.library.adapter4.loadState.LoadState
import com.chad.library.adapter4.loadState.trailing.TrailingLoadStateAdapter

class ResultActivity : BaseActivity<ActivityResultBinding>() {

    private lateinit var newsAdapter: NewsAdapter
    private lateinit var helper: QuickAdapterHelper
    private val TAG = "ResultActivity"
    private var isLoading = false

    override val binding: ActivityResultBinding by lazy {
        ActivityResultBinding.inflate(layoutInflater)
    }

    @SuppressLint("SetTextI18n")
    override fun initView() {
        BarUtils.setStatusBarLightMode(this, true)
        BarUtils.setStatusBarColor(this, Color.TRANSPARENT)
//        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())

        val from = intent.getStringExtra("from")
        when (from) {
            JUNK_CLEANER -> {
                val cleanSize = intent.getLongExtra("clean_size", 0L)
                if (cleanSize > 0) {
                    binding.tvTip.text = "Cleaned up ${cleanSize.toFormatSize(1)}"
                } else {
                    binding.tvTip.text = "No junk files found."
                }
            }

            APP_PROCESS -> {
                binding.tvTip.text = "Complete!"
            }
        }
        newsAdapter = NewsAdapter(false,
            clickAction = { url ->
                startActivity(Intent(this, NewsDetailActivity::class.java).apply {
                    putExtra("url", url)
                })
            },
            moreAction = {

            }
        )
        helper =
            QuickAdapterHelper.Builder(newsAdapter).setTrailingLoadStateAdapter(object : TrailingLoadStateAdapter.OnTrailingListener {
                override fun onLoad() {
                    LogEx.logDebug(TAG, "onLoad")
                    requestMore()
                }

                override fun onFailRetry() {
                    LogEx.logDebug(TAG, "onFailRetry")
                    requestMore()
                }

                override fun isAllowLoading(): Boolean {
                    LogEx.logDebug(TAG, "isLoading=$isLoading")
                    return !isLoading
                }
            }).build()
        binding.rvNews.adapter = helper.adapter
        requestMore()
    }

    override fun initListener() {
        super.initListener()
        onBackPressedDispatcher.addCallback {
            finishToMain()
        }
        binding.flFanhui.setOnClickListener {
            onBackPressedDispatcher.onBackPressed()
        }
        binding.tvFunctionBtn.setOnClickListener {
            startActivity(Intent(this, AppProcessActivity::class.java))
            finish()
        }
    }

    fun requestMore() {
        isLoading = true
        helper.trailingLoadState = LoadState.None
        val lastNewsId = newsAdapter.getLastPageNumber()
        LogEx.logDebug(TAG, "requestMore lastNewsId=$lastNewsId")
        NewsUtils.requestNews(pageNumber = lastNewsId, errorCallBack = {
            isLoading = false
            LogEx.logDebug(TAG, "errorCallBack")
        }, beanCallBack = {
            isLoading = false
            binding.root.post {
                LogEx.logDebug(TAG, "beanCallBack")
                if (lastNewsId == null) {
                    newsAdapter.submitList(it)
                } else {
                    newsAdapter.addAll(it)
                }
                helper.trailingLoadState = LoadState.NotLoading(false)
            }

        })
    }


}