package com.base.browserwhite.ui.activity.news

import android.graphics.Color
import androidx.activity.addCallback
import androidx.core.view.updatePadding
import androidx.fragment.app.FragmentTransaction
import com.base.browserwhite.R
import com.base.browserwhite.ads.AdmobMaxHelper
import com.base.browserwhite.databinding.ActivityNewsDetailBinding
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.ui.activity.webbrowser.WebViewFragment
import com.base.browserwhite.utils.BarUtils

class NewsDetailActivity : BaseActivity<ActivityNewsDetailBinding>() {

    override val binding: ActivityNewsDetailBinding by lazy {
        ActivityNewsDetailBinding.inflate(layoutInflater)
    }
    private var currentFragment: WebViewFragment? = null

    override fun initView() {
        BarUtils.setStatusBarLightMode(this, true)
        BarUtils.setStatusBarColor(this, Color.TRANSPARENT)
        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())

        val url = intent.extras?.getString("url") ?: ""
        addNewWebSite(url)
    }

    override fun initListener() {
        super.initListener()
        onBackPressedDispatcher.addCallback {
            finishToMain()
        }
        binding.flFanhui.setOnClickListener {
            onBackPressedDispatcher.onBackPressed()
        }
    }

    private fun addNewWebSite(uri: String) {
        val myFragment = WebViewFragment().apply { url = uri }
        myFragment.onPageFinished = {
            AdmobMaxHelper.admobMaxShowInterstitialAd(this, false) {

            }
        }
        val transaction: FragmentTransaction = supportFragmentManager.beginTransaction()
        transaction.replace(R.id.container, myFragment)
        transaction.commit()
        currentFragment = myFragment
    }
}