package com.base.browserwhite.ui.activity.mediabrowser

import android.graphics.Color
import android.net.Uri
import androidx.activity.addCallback
import androidx.core.view.updatePadding
import com.base.browserwhite.ads.AdmobMaxHelper
import com.base.browserwhite.databinding.ActivityMediaImageDetailBinding
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.ui.views.DialogViews.showDeleteTipDialog
import com.base.browserwhite.utils.BarUtils
import com.base.browserwhite.utils.IntentEx.shareAction
import com.base.browserwhite.utils.LogEx
import com.bumptech.glide.Glide
import java.io.File

class MediaImageDetailActivity : BaseActivity<ActivityMediaImageDetailBinding>() {

    private val TAG = "MediaImageDetailActivity"

    override val binding: ActivityMediaImageDetailBinding by lazy {
        ActivityMediaImageDetailBinding.inflate(layoutInflater)
    }
    private var uri: String = ""

    override fun initView() {
        BarUtils.setStatusBarLightMode(this, true)
        BarUtils.setStatusBarColor(this, Color.WHITE)
        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())

        uri = intent.extras?.getString("uri") ?: ""
        LogEx.logDebug(TAG, "uri=$uri")

        val path = intent.extras?.getString("path") ?: ""
        Glide.with(this).load(path).fitCenter().into(binding.iv)


    }

    override fun initListener() {
        super.initListener()
        onBackPressedDispatcher.addCallback {
            AdmobMaxHelper.admobMaxShowInterstitialAd(this@MediaImageDetailActivity, false) {
                finish()
            }
        }
        binding.ivFanhui.setOnClickListener { onBackPressedDispatcher.onBackPressed() }

        binding.ivDelete.setOnClickListener {
            showDeleteTipDialog {
                val path = intent.extras?.getString("path") ?: ""
                val file = File(path)
                runCatching {
                    file.delete()
                }
                finish()
            }
        }
        binding.ivShare.setOnClickListener {
            this.shareAction(Uri.parse(uri), intent.extras?.getString("mimeType") ?: "")
        }
    }

}