package com.base.browserwhite.ui.activity.labelstack

import android.graphics.Color
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import androidx.recyclerview.widget.RecyclerView.ViewHolder
import com.base.browserwhite.R
import com.base.browserwhite.bean.LabelBean
import com.base.browserwhite.databinding.ItemLabelBinding
import com.base.browserwhite.utils.XmlEx.inflate
import kotlin.random.Random

class LabelAdapter : RecyclerView.Adapter<LabelAdapter.LabelViewHolder>() {

    inner class LabelViewHolder(view: View) : ViewHolder(view)

    private var beanList = arrayListOf(
        LabelBean(),
        LabelBean(),
        LabelBean()
    )

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): LabelViewHolder {
        return LabelViewHolder(R.layout.item_label.inflate(parent))
    }

    override fun getItemCount(): Int {
        return beanList.size
    }

    override fun onBindViewHolder(holder: LabelViewHolder, position: Int) {
        val binding = ItemLabelBinding.bind(holder.itemView)
        binding.root.setCardBackgroundColor(generateRandomColor())
    }

    fun generateRandomColor(): Int {
        // 生成随机的 Alpha（透明度）、Red（红色）、Green（绿色）、Blue（蓝色）值
        val alpha = Random.nextInt(255) // 透明度，从 0 到 255，然后右移24位，确保在 0xFF 范围内
        val red = Random.nextInt(256)
        val green = Random.nextInt(256)
        val blue = Random.nextInt(256)

        // 将ARGB值组合成一个颜色值
        return Color.argb(alpha, red, green, blue)
    }
}