package com.base.browserwhite.ui.activity.feedback

import android.annotation.SuppressLint
import android.graphics.Color
import androidx.core.view.updatePadding
import androidx.core.widget.addTextChangedListener
import com.base.browserwhite.databinding.ActivityFeedbackBinding
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.utils.BarUtils

class FeedbackActivity : BaseActivity<ActivityFeedbackBinding>() {

    override val binding: ActivityFeedbackBinding by lazy {
        ActivityFeedbackBinding.inflate(layoutInflater)
    }


    override fun initView() {

        BarUtils.setStatusBarLightMode(this, true)
        BarUtils.setStatusBarColor(this, Color.WHITE)
        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())


    }

    @SuppressLint("SetTextI18n")
    override fun initListener() {
        super.initListener()
        binding.edit.addTextChangedListener {
            binding.tvNumber.text = "${it?.toString()?.length ?: 0}/500"
            binding.tvSubmit.isEnabled = !it.isNullOrEmpty()
        }
        binding.editEmail.addTextChangedListener {
            binding.tvSubmit.isEnabled = !it.isNullOrEmpty()
        }

        binding.fl1.setOnClickListener {

        }

    }
}
