package com.base.browserwhite.ui.activity.download

import android.content.Intent
import android.graphics.Color
import android.view.View
import androidx.activity.addCallback
import androidx.core.view.updatePadding
import androidx.fragment.app.Fragment
import androidx.viewpager2.adapter.FragmentStateAdapter
import androidx.viewpager2.widget.ViewPager2
import com.base.browserwhite.R
import com.base.browserwhite.databinding.ActivityWebDownloadGuideBinding
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.ui.activity.webbrowser.WebBrowserActivity
import com.base.browserwhite.utils.BarUtils
import com.zhpan.indicator.enums.IndicatorSlideMode
import com.zhpan.indicator.enums.IndicatorStyle

class WebDownloadGuideActivity : BaseActivity<ActivityWebDownloadGuideBinding>() {

    private val fragment1: DownloadGuideFragment by lazy {
        DownloadGuideFragment(0)
    }
    private val fragment2: DownloadGuideFragment by lazy {
        DownloadGuideFragment(1)
    }
    private val fragment3: DownloadGuideFragment by lazy {
        DownloadGuideFragment(2)
    }
    private val fragment4: DownloadGuideFragment by lazy {
        DownloadGuideFragment(3)
    }
    private var currentPosition: Int = 0

    private val fragments by lazy {
        mutableListOf(fragment1, fragment2, fragment3, fragment4)
    }


    override val binding: ActivityWebDownloadGuideBinding by lazy {
        ActivityWebDownloadGuideBinding.inflate(layoutInflater)
    }


    override fun initView() {
        BarUtils.setStatusBarLightMode(this, true)
        BarUtils.setStatusBarColor(this, Color.TRANSPARENT)
        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())

        binding.viewPager2.run {
            adapter = object : FragmentStateAdapter(this@WebDownloadGuideActivity) {
                override fun getItemCount(): Int {
                    return fragments.size
                }

                override fun createFragment(position: Int): Fragment {
                    return fragments[position]
                }
            }
        }
        binding.viewPager2.registerOnPageChangeCallback(object :
            ViewPager2.OnPageChangeCallback() {

            override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {
                super.onPageScrolled(position, positionOffset, positionOffsetPixels)
                binding.indicatorView.onPageScrolled(position, positionOffset, positionOffsetPixels)
            }


            override fun onPageSelected(position: Int) {
                currentPosition = position
                binding.indicatorView.onPageSelected(position)
                if (currentPosition > 0) {
                    binding.ivBefore.visibility = View.VISIBLE
                } else {
                    binding.ivBefore.visibility = View.INVISIBLE
                }
                if (currentPosition < 3) {
                    binding.ivNext.visibility = View.VISIBLE
                    binding.flTry.visibility = View.INVISIBLE
                    binding.indicatorView.visibility = View.VISIBLE
                } else {
                    binding.indicatorView.visibility = View.INVISIBLE
                    binding.ivNext.visibility = View.INVISIBLE
                    binding.flTry.visibility = View.VISIBLE
                }
            }
        })
        binding.indicatorView.apply {
            val normalColor = Color.parseColor("#1E5385")
            val checkedColor = Color.parseColor("#FFFFFF")
            setSliderColor(normalColor, checkedColor)
            setSliderWidth(resources.getDimension(R.dimen.dp_18))
            setSliderHeight(resources.getDimension(R.dimen.dp_7))
            setSlideMode(IndicatorSlideMode.WORM)
            setIndicatorStyle(IndicatorStyle.ROUND_RECT)
            setPageSize(4)
            notifyDataChanged()
        }
    }

    override fun initListener() {
        super.initListener()
        onBackPressedDispatcher.addCallback { finishToMain() }
        binding.flFanhui.setOnClickListener {
            onBackPressedDispatcher.onBackPressed()
        }
        binding.ivBefore.setOnClickListener {
            val index = currentPosition - 1
            if (index < 0) return@setOnClickListener
            binding.viewPager2.currentItem = index
        }
        binding.ivNext.setOnClickListener {
            val index = currentPosition + 1
            if (index > 3) return@setOnClickListener
            binding.viewPager2.currentItem = index
        }
        binding.flTry.setOnClickListener {
            startActivity(Intent(this, WebBrowserActivity::class.java).apply {
                putExtra("url", "https://mixkit.co/free-stock-video/girl-dancing-happily-in-a-field-of-flowers-4702/")
            })
            finish()
        }
    }

}