package com.base.browserwhite.ui.activity.download

import android.annotation.SuppressLint
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.marginRight
import com.base.browserwhite.R
import com.base.browserwhite.databinding.FragmentDownloadGuideBinding
import com.base.browserwhite.ui.fragment.BaseFragment

class DownloadGuideFragment() : BaseFragment<FragmentDownloadGuideBinding>() {

    private var index = 0

    constructor(index: Int) : this() {
        this.index = index
    }

    override val binding: FragmentDownloadGuideBinding by lazy {
        FragmentDownloadGuideBinding.inflate(layoutInflater)
    }


    @SuppressLint("SetTextI18n")
    override fun setView() {
        when (index) {
            0 -> {
                binding.iv.setImageResource(R.mipmap.tu1)
                binding.tv.text = "Search for video name"
            }

            1 -> {
                binding.iv.setImageResource(R.mipmap.tu2)
                binding.tv.text = "Select the video to download"
            }

            2 -> {
                binding.iv.setImageResource(R.mipmap.tu3)
                binding.tv.text = "Play Video"
            }

            3 -> {
                binding.iv.setImageResource(R.mipmap.tu4)
                val params = binding.iv.layoutParams as ConstraintLayout.LayoutParams
                val left = requireContext().resources.getDimensionPixelOffset(R.dimen.dp_20)
                params.setMargins(left, 0, 0, 0)
                binding.iv.layoutParams = params
                binding.tv.text = "Click the button to download\n" + "the video"
            }

        }
    }


}