package com.base.browserwhite.ui.activity.download

import android.app.AlertDialog
import android.content.Context
import android.content.Intent
import android.view.KeyEvent
import android.view.LayoutInflater
import android.view.View
import android.view.inputmethod.EditorInfo
import android.view.inputmethod.InputMethodManager
import android.widget.TextView
import android.widget.TextView.OnEditorActionListener
import android.widget.Toast
import com.base.browserwhite.R
import com.base.browserwhite.bean.DownloadBean
import com.base.browserwhite.databinding.DialogDownloadConfirmBinding
import com.base.browserwhite.databinding.DialogDownloadFinishBinding
import com.base.browserwhite.databinding.DialogDownloadVideoBinding
import com.base.browserwhite.utils.KotlinExt.toFormatSize
import com.base.browserwhite.utils.LogEx
import com.bumptech.glide.Glide
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog

object DownloadDialog {


    fun Context.showDownloadVideoDialog(
        adapter: DownloadAdapter,
        list: List<DownloadBean>,
        dismissAction: () -> Unit
    ) {
        val TAG = "DownloadVideoDialog"
        val dialog = BottomSheetDialog(this,R.style.BottomSheetDialog)
        val binding = DialogDownloadVideoBinding.inflate(LayoutInflater.from(this))
        dialog.setContentView(binding.root)
        dialog.setCanceledOnTouchOutside(false)

        dialog.show()

        val itemHeight = resources.getDimensionPixelOffset(R.dimen.dp_97)
        LogEx.logDebug(TAG, "itemHeight=$itemHeight")
        if (list.size > 3) {
            val recyclerViewHeight: Int = 3 * itemHeight
            binding.rv.layoutParams.height = recyclerViewHeight
            binding.rv.requestLayout()
        }

        val parentView = binding.root.parent as View
        val behavior = BottomSheetBehavior.from(parentView)
        //展开
        behavior.state = BottomSheetBehavior.STATE_EXPANDED

        adapter.downloadAction = {
            dialog.dismiss()
        }

        binding.rv.adapter = adapter
        adapter.submitList(list)

        dialog.setOnDismissListener {
            dismissAction.invoke()
        }
        binding.tvDownloadDir.setOnClickListener {
            dialog.dismiss()
            startActivity(Intent(this, WebDownloadManagerActivity::class.java))
        }
    }

    fun Context.showDownloadConfirmDialog(item: DownloadBean, download: () -> Unit) {
        val dialog = BottomSheetDialog(this,R.style.BottomSheetDialog)
        val binding = DialogDownloadConfirmBinding.inflate(LayoutInflater.from(this))
        dialog.setContentView(binding.root)
        dialog.setCanceledOnTouchOutside(false)
        dialog.show()

        val parentView = binding.root.parent as View
        val behavior = BottomSheetBehavior.from(parentView)
        //展开
        behavior.state = BottomSheetBehavior.STATE_EXPANDED

        Glide.with(this).load(item.url).centerCrop().into(binding.iv)
        binding.editName.setText(item.url.split("/").last())
        binding.tvSize.text=item.size.toFormatSize()
        binding.ivEdit.setOnClickListener {
            binding.editName.isEnabled = true
            binding.editName.setBackgroundResource(android.R.drawable.edit_text)
            binding.editName.requestFocus()
        }
        binding.editName.setOnFocusChangeListener { v, hasFocus ->
            if (hasFocus) {
                val imm = getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager?
                imm?.showSoftInput(v, InputMethodManager.SHOW_IMPLICIT)
            }
        }
        binding.editName.setOnEditorActionListener(object : OnEditorActionListener {
            override fun onEditorAction(v: TextView?, actionId: Int, event: KeyEvent?): Boolean {
                if (actionId == EditorInfo.IME_ACTION_DONE) {
                    binding.editName.isEnabled = false
                    binding.editName.background = null
                    return true
                }
                return false
            }
        })
        binding.tvCancel.setOnClickListener {
            dialog.dismiss()
        }
        binding.tvConfirm.setOnClickListener {
            if (binding.editName.text.isNullOrEmpty()) {
                Toast.makeText(this, "name is empty", Toast.LENGTH_SHORT).show()
                return@setOnClickListener
            }
            item.name = binding.editName.text.toString()
            dialog.dismiss()
            download.invoke()
        }

    }


    fun Context.showDownloadFinishDialog() {
        val binding = DialogDownloadFinishBinding.inflate(LayoutInflater.from(this))
        val dialog = AlertDialog.Builder(this).create()
        dialog.setView(binding.root)

        dialog.show()
        val params = dialog.window?.attributes
        params?.width = resources.getDimensionPixelOffset(R.dimen.dp_335)
        dialog.window?.attributes = params
        dialog.window?.setBackgroundDrawableResource(android.R.color.transparent)
    }

}