package com.base.browserwhite.ui.activity.cleanjunk

import android.animation.ValueAnimator
import android.content.Intent
import android.graphics.Color
import android.view.animation.LinearInterpolator
import android.widget.Toast
import androidx.activity.addCallback
import androidx.core.animation.doOnEnd
import androidx.core.view.updatePadding
import com.base.browserwhite.bean.ConstObject.JUNK_CLEANER
import com.base.browserwhite.databinding.ActivityLayoutCleanupingBinding
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.ui.activity.result.ResultActivity
import com.base.browserwhite.utils.AppPreferences
import com.base.browserwhite.utils.BarUtils
import com.base.browserwhite.utils.MediaStoreUtils.updateMediaStore
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch
import java.io.File
import kotlin.random.Random

/**
 * 实际清理页面
 */
class CleaningActivity : BaseActivity<ActivityLayoutCleanupingBinding>() {

    override val binding: ActivityLayoutCleanupingBinding by lazy {
        ActivityLayoutCleanupingBinding.inflate(layoutInflater)
    }
    private val intentSize by lazy {
        intent.getLongExtra("size", -1)
    }
    private val listPath by lazy {
        intent.getStringArrayExtra("list") ?: arrayOf()
    }

    override fun initView() {
        BarUtils.setStatusBarColor(this, Color.TRANSPARENT)
        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())

        MainScope().launch(Dispatchers.IO) {
            try {
                listPath.forEach {
                    val file = File(it)
                    runCatching { file.deleteRecursively() }
                }
                updateMediaStore(listPath)
            } catch (_: Exception) {
            } finally {

            }

        }
        playAnm()
    }

    override fun initListener() {
        onBackPressedDispatcher.addCallback {
            Toast.makeText(this@CleaningActivity, "wait a moment", Toast.LENGTH_SHORT).show()
        }
    }

    private fun playAnm() {
        ValueAnimator.ofFloat(0f, 360f).run {
            duration = 1000
            repeatMode = ValueAnimator.RESTART
            repeatCount = ValueAnimator.INFINITE
            interpolator = LinearInterpolator()
            addUpdateListener {
                binding.idYuan.rotation = it.animatedValue as Float
            }
            start()
        }
        ValueAnimator.ofInt(0, 100).run {
            duration = Random.nextLong(7000, 8000)
            interpolator = LinearInterpolator()
            addUpdateListener {
                binding.idTvJd.text = "${it.animatedValue as Int}"
            }
            doOnEnd {
                val isCleanEndAdSp = AppPreferences.getInstance().getString("isCleanEndAdSp", "1").toInt()
                if (isCleanEndAdSp == 1) {
                    com.base.browserwhite.ads.AdmobMaxHelper.admobMaxShowInterstitialAd(this@CleaningActivity) {
                        startActivity(
                            Intent(this@CleaningActivity, ResultActivity::class.java).putExtra("from", JUNK_CLEANER)
                                .putExtra("clean_size", intentSize)
                        )
                        finish()
                    }
                } else {
                    startActivity(
                        Intent(this@CleaningActivity, ResultActivity::class.java).putExtra("from", JUNK_CLEANER)
                            .putExtra("clean_size", intentSize)
                    )
                    finish()
                }
            }
            start()
        }
    }
}