package com.base.browserwhite.ui.activity.bookmark

import android.content.Context
import android.graphics.drawable.ColorDrawable
import android.view.View
import android.view.ViewGroup
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView.ViewHolder
import com.base.browserwhite.R
import com.base.browserwhite.bean.HistoryBean
import com.base.browserwhite.databinding.ItemBookmarkHistoryBinding
import com.base.browserwhite.utils.XmlEx.inflate
import com.chad.library.adapter4.BaseQuickAdapter

class HistoryAdapter : BaseQuickAdapter<HistoryBean, HistoryAdapter.HistoryViewHolder>() {
    inner class HistoryViewHolder(view: View) : ViewHolder(view)

    var moreAction: ((item: HistoryBean) -> Unit)? = null
    override fun onBindViewHolder(holder: HistoryViewHolder, position: Int, item: HistoryBean?) {

        if (item == null) return

        val binding = ItemBookmarkHistoryBinding.bind(holder.itemView)
        binding.flTime.isVisible = item.showTime
        binding.tvLetters.background = ColorDrawable(item.color)
        if (item.name.isNotEmpty()) {
            binding.tvLetters.text = item.name.first().toString()
            binding.tvName.text = item.name
        }
        binding.flOpeartion.setOnClickListener {
            moreAction?.invoke(item)
        }
    }

    override fun onCreateViewHolder(context: Context, parent: ViewGroup, viewType: Int): HistoryViewHolder {
        return HistoryViewHolder(R.layout.item_bookmark_history.inflate(parent))
    }
}