package com.base.browserwhite.ui.activity.bookmark

import android.graphics.Color
import androidx.activity.addCallback
import androidx.core.view.updatePadding
import androidx.core.widget.addTextChangedListener
import com.base.browserwhite.bean.BookmarkBean
import com.base.browserwhite.databinding.ActivityBookmarkFolderEditBinding
import com.base.browserwhite.ui.activity.BaseActivity
import com.base.browserwhite.utils.BarUtils
import com.base.browserwhite.utils.SpBeanUtils
import com.base.browserwhite.utils.SpBeanUtils.BOOKMARK_SP_KEY

/**
 * 添加编辑书签
 */
class BookmarkFolderEditActivity : BaseActivity<ActivityBookmarkFolderEditBinding>() {

    override val binding: ActivityBookmarkFolderEditBinding by lazy {
        ActivityBookmarkFolderEditBinding.inflate(layoutInflater)
    }

    override fun initView() {
        BarUtils.setStatusBarLightMode(this, true)
        BarUtils.setStatusBarColor(this, Color.WHITE)
        binding.root.updatePadding(top = BarUtils.getStatusBarHeight())

        editFolder?.let { binding.editName.setText(it.name) }

    }

    override fun initListener() {
        super.initListener()
        onBackPressedDispatcher.addCallback {
            finish()
        }
        binding.flFanhui.setOnClickListener {
            onBackPressedDispatcher.onBackPressed()
        }

        binding.editName.addTextChangedListener {
            binding.tvSave.isEnabled = !it.isNullOrEmpty()
        }

        binding.tvSave.setOnClickListener {
            if (editFolder == null) {
                editFolder = BookmarkBean(name = binding.editName.text.toString(), isFolder = true)
                editFolder?.let { SpBeanUtils.addSpBean(BOOKMARK_SP_KEY, it) }
            } else {
                editFolder?.let {
                    it.name = binding.editName.text.toString()
                    SpBeanUtils.editSpBean(BOOKMARK_SP_KEY, it)
                }
            }
            finish()
        }
    }

    companion object {
        var editFolder: BookmarkBean? = null
    }

}